// html.h - HTML parser functions
#ifndef __HTML_H__
#define __HTML_H__

#include "elist.h"

#define EB_HTML_BODY    0
#define EB_HTML_TEXT    1
#define EB_HTML_NEWLINE 2
#define EB_HTML_ENCODED 3 // quoted, eg &lt;
#define EB_HTML_FONT    4
#define EB_HTML_LINK    5
#define EB_HTML_ATTRIB  6

typedef struct _eb_html_item
{
  int type;
  void * data;

  EList * contents;
} eb_html_item;

typedef struct _eb_font_data
{
  char * face;
  int col; // does it specify a colour?
  unsigned char r, g, b;
  int size;
  int size_abs; // is the size absolute?
} eb_font_data;

typedef struct _eb_link_data
{
  char * target;
} eb_link_data;

typedef struct _eb_encoded_data
{
  char real;
  char * encoded;
} eb_encoded_data;

#define EB_HTML_BOLD   0
#define EB_HTML_ITALIC 1
#define EB_HTML_ULINE  2

typedef struct _eb_attrib_data
{
  int attrib; // eg EB_HTML_BOLD
  int state;  // 1 to switch on, 0 to switch off
} eb_attrib_data;

extern eb_encoded_data html_encoding[];

#ifdef __cplusplus
extern "C" {
#endif

eb_html_item * eb_html_parse(char * string);

char * eb_html_render(eb_html_item * item);
char * eb_html_render_plain(eb_html_item * item);

void eb_html_destroy(eb_html_item * item);

#ifdef __cplusplus
}
#endif

#endif // __HTML_H__
