// gui_comms.h

#ifndef __GUI_COMMS_H__
#define __GUI_COMMS_H__

#include "plugin.h"
#include "plugin_api.h"
#include "contactlist.h"
#include "html.h"

typedef struct _eb_gui
{
  int read_fd;
  int write_fd;
  int tag;
  char ** params;
  int * lengths;
  int num_params; // 0 means the next "readable" event heralds a new command
  int params_arrived;
  unsigned char cookie[8];
  int cookie_progress;

  int html; // does it want HTML (true) or plaintext (false)?
  int msg_capable; // is it up to handling messages? (affects whether to go into auto-message-hold on UI d/c)

  EList * streams;
} eb_gui;


#ifdef __cplusplus
extern "C" {
#endif

int eb_gui_socket(int * port);
int eb_gui_comms_init(int port);
void eb_gui_connected(void *data, int source, int condition);
void eb_gui_incoming(void *data, int source, eb_input_condition condition);

void eb_gui_send(eb_gui * gui, char ** command, int num_params);
void eb_gui_send_data(eb_gui * gui, char ** command, int * lengths, int num_params);
void eb_gui_broadcast(char ** command, int num_params);

void eb_gui_welcome(eb_gui * gui);

void eb_buddy_logout(eb_account * acc);
#define eb_buddy_update_status(x) eb_buddy_update(x)
void eb_buddy_update(eb_account * acc);
void eb_buddy_login(eb_account * acc);

void eb_local_account_update(eb_local_account * acc);

void eb_gui_list_contacts(eb_gui * gui, char ** params, int * lengths, int num_params);
void eb_gui_list_accounts(eb_gui * gui, char ** params, int * lengths, int num_params);

void eb_gui_resolve_dialog(eb_gui * gui, char ** params, int * lengths, int num_params);
void eb_do_client_error(eb_gui * gui, char * error);

void eb_gui_send_message(eb_gui * gui, char ** params, int * lengths, int num_params);

void eb_gui_got_message(eb_account * remote, eb_html_item * message);
void eb_gui_notify_3rdperson(eb_contact * contact, eb_html_item * message);
void eb_gui_sent_message(eb_account * remote, eb_html_item * message);
void eb_gui_data_message(eb_account * remote, char * filename, char * contenttype, char * disposition, char * suggested_filename, int length, int direction, int held);

void eb_gui_announce_group_chat(eb_gui * gui, eb_group_chat * chat);

void eb_gui_get_held_messages(eb_gui * gui, char ** params, int * lengths, int num_params);

void new_plugin_notify(eb_plugin * p);
void plugin_update_notify(eb_plugin * p);

#ifdef __cplusplus
}
#endif

extern EList * GUIs;
extern int eb_quit_on_last;
extern unsigned char eb_authcookie[];

#endif // __GUI_COMMS_H__
