// groupchat.h
#ifndef __GROUPCHAT_H__
#define __GROUPCHAT_H__

typedef struct _eb_group_chat {
  int id;
  int announced;
  char * title;
  eb_local_account * account;
  EList * users;
  void * protocol_data;
  
  FILE * logfile;
  time_t log_begins;
} eb_group_chat;

typedef struct _eb_group_chat_user {
  eb_group_chat * chat;
  char * handle;
//  eb_account * account; - is there any point to this?
} eb_group_chat_user;

extern EList * group_chats;
extern int next_groupchat_id;

#ifdef __cplusplus
extern "C" {
#endif

eb_group_chat * eb_create_group_chat(eb_local_account * acc);
void eb_announce_group_chat(eb_group_chat * chat);

void eb_group_chat_joined(eb_group_chat * chat, char * handle);
void eb_group_chat_left(eb_group_chat * chat, char * handle);

void eb_group_chat_message(eb_group_chat * chat, char * handle, char * msg);
void eb_group_chat_3rdperson(eb_group_chat * chat, char * msg);

void eb_destroy_group_chat(eb_group_chat * chat);
void eb_hide_group_chat(eb_group_chat * chat);

#ifdef __cplusplus
}
#endif

#endif // __GROUPCHAT_H__
