
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dialog.h"
#include "html.h"
#include "gui_comms.h"
#include "groupchat.h"

EList * group_chats=NULL;
int next_groupchat_id=1;

eb_group_chat * eb_create_group_chat(eb_local_account * acc)
{
  eb_group_chat * chat=(eb_group_chat *)malloc(sizeof(eb_group_chat));

  chat->id=next_groupchat_id++;
  chat->account=acc;
  chat->title=strdup("Everybuddy Group chat");
  chat->users=NULL;
  chat->announced=0;

  group_chats=e_list_append(group_chats, chat);
  acc->group_chats=e_list_append(acc->group_chats, chat);

  return chat;
}

void eb_gui_announce_group_chat(eb_gui * gui, eb_group_chat * chat)
{
  char buf[16];
  char * announce[]={"new_group_chat", "", "", buf, ""};
  char * list_user[]={"list_group_user", buf, ""};
  char * end_list[]={"list_group_chat_done"};
  EList * n;

  sprintf(buf, "%d", chat->id);

  announce[1]=chat->account->handle;
  announce[2]=chat->account->service_name;
  announce[4]=chat->title;

  if(gui==NULL)
  {
    eb_gui_broadcast(announce, 5);
  } else {
    eb_gui_send(gui, announce, 5);
  }

  for(n=chat->users; n!=NULL; n=n->next)
  {
    eb_group_chat_user * user=(eb_group_chat_user *)n->data;

    list_user[2]=user->handle;

    if(gui==NULL)
    {
      eb_gui_broadcast(list_user, 3);
    } else {
      eb_gui_send(gui, list_user, 3);
    }
  }

  if(gui==NULL)
  {
    eb_gui_broadcast(end_list, 1);
  } else {
    eb_gui_send(gui, end_list, 1);
  }
}

void eb_announce_group_chat(eb_group_chat * chat)
{
  if(chat->announced) { return; }

  eb_gui_announce_group_chat(NULL, chat);

  chat->announced=1;
}

void eb_update_group_chat(eb_group_chat * chat)
{
  char buf[16];
  char * notify_cmd[]={"group_chat_update", buf, ""};

  if(!chat->announced) { return; }

  sprintf(buf, "%d", chat->id);
  notify_cmd[2]=chat->title;

  eb_gui_broadcast(notify_cmd, 3);
}

void eb_group_chat_joined(eb_group_chat * chat, char * handle)
{
  eb_group_chat_user * user=(eb_group_chat_user *)malloc(sizeof(eb_group_chat_user));

  user->chat=chat;
  user->handle=strdup(handle);

  chat->users=e_list_append(chat->users, user);

  if(chat->announced)
  {
    char buf[16];
    char * announce[]={"group_chat_joined", buf, handle};

    sprintf(buf, "%d", chat->id);

    eb_gui_broadcast(announce, 3);
  }
}

void eb_group_chat_left(eb_group_chat * chat, char * ahandle)
{
  EList * n;
  char * handle=strdup(ahandle);

  for(n=chat->users; n!=NULL; n=n->next)
  {
    eb_group_chat_user * user=(eb_group_chat_user *)n->data;
    if(!strcmp(user->handle, handle))
    {
      chat->users=e_list_remove_link(chat->users, n);
      e_list_free_1(n);

      free(user->handle);
      free(user);

      break;
    }
  }

  if(n==NULL)
  {
    eb_show_error("Internal error: Leaving user not in chat!", "Internal error");
    free(handle);
    return;
  }

  if(chat->announced)
  {
    char buf[16];
    char * announce[]={"group_chat_left", buf, handle};

    sprintf(buf, "%d", chat->id);

    eb_gui_broadcast(announce, 3);
  }
  free(handle);
}

void eb_group_chat_highlight(eb_html_item * parsed)
{
  eb_html_item * fitem=(eb_html_item *)calloc(sizeof(eb_html_item), 1);
  eb_font_data * fdata=(eb_font_data *)calloc(sizeof(eb_font_data), 1);

  fitem->type=EB_HTML_FONT;
  fitem->data=fdata;
  fdata->col=1;
  fdata->r=128;

  fitem->contents=parsed->contents;
  parsed->contents=e_list_append(NULL, fitem);
}

void eb_group_chat_message(eb_group_chat * chat, char * handle, char * msg)
{
  eb_html_item * parsed=eb_html_parse(msg);
  char * plain=eb_html_render_plain(parsed);
  char * html=eb_html_render(parsed);
  char buf[16];
  char * announce[]={"group_chat_recv", buf, handle, msg};
  EList * n;

  if(!chat->announced) { eb_announce_group_chat(chat); }

  if(eb_get_value(registry, "config/groupchat/hilight")[0]=='1'
   || strstr(plain, chat->account->handle))
  {
    eb_group_chat_highlight(parsed);
  }

  sprintf(buf, "%d", chat->id);

  for(n=GUIs; n!=NULL; n=n->next)
  {
    eb_gui * gui=(eb_gui *)n->data;

    announce[3]=(gui->html)?(html):(plain);

    eb_gui_send(gui, announce, 4);
  }

  free(html);
  free(plain);
  eb_html_destroy(parsed);
}

void eb_group_chat_3rdperson(eb_group_chat * chat, char * msg)
{
  eb_html_item * parsed=eb_html_parse(msg);
  char * plain=eb_html_render_plain(parsed);
  char * html=eb_html_render(parsed);
  char buf[16];
  char * announce[]={"group_chat_3rdperson", buf, msg};
  EList * n;

  if(!chat->announced) { eb_announce_group_chat(chat); }

  sprintf(buf, "%d", chat->id);

  if(eb_get_value(registry, "config/groupchat/hilight")[0]=='1'
   || strstr(plain, chat->account->handle))
  {
    eb_group_chat_highlight(parsed);
  }

  for(n=GUIs; n!=NULL; n=n->next)
  {
    eb_gui * gui=(eb_gui *)n->data;

    announce[2]=(gui->html)?(html):(plain);

    eb_gui_send(gui, announce, 3);
  }

  free(html);
  free(plain);
  eb_html_destroy(parsed);
}

void eb_destroy_group_chat(eb_group_chat * chat)
{
  EList * n;

  eb_hide_group_chat(chat);

  group_chats=e_list_remove(group_chats, chat);
  chat->account->group_chats=e_list_remove(chat->account->group_chats, chat);

  for(n=chat->users; n!=NULL; n=n->next)
  {
    eb_group_chat_user * user=(eb_group_chat_user *)n->data;

    free(user->handle);
    free(user);
  }

  e_list_free(chat->users);

  free(chat->title);
  free(chat);
}

void eb_hide_group_chat(eb_group_chat * chat)
{
  if(chat->announced)
  {
    char buf[16];
    char * announce[]={"close_group_chat", buf};

    sprintf(buf, "%d", chat->id);
    eb_gui_broadcast(announce, 2);

    chat->announced=0;
  }
}

