// elist.h

#ifndef __ELIST_H__
#define __ELIST_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _EList {
  struct _EList * next;
  struct _EList * prev;
  void * data;
} EList;

typedef int (*EListCompFunc)(const void *, const void *);

EList * e_list_append(EList * list, void * data);
EList * e_list_insert(EList * head, EList * before, void * data);
EList * e_list_remove_link(EList * list, EList * link);
EList * e_list_remove(EList * list, void * data);

EList * e_list_copy(EList * list);

void e_list_free_1(EList * list);
void e_list_free(EList * list);
int e_list_length(EList * list);

EList * e_list_find_custom(EList * list, void * data, EListCompFunc comp);

#ifdef __cplusplus
}
#endif

#endif // __ELIST_H__
