/***************************************************************************
                    elist.c - Linked list implementation
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include "elist.h"

EList * e_list_append(EList * list, void * data)
{
  EList * n;
  EList * new_list=(EList *)malloc(sizeof(EList));
  EList * attach_to=NULL;

  new_list->next=NULL;
  new_list->data=data;

  for(n=list; n!=NULL; n=n->next)
  {
    attach_to=n;
  }

  if(attach_to==NULL)
  {
    new_list->prev=NULL;
    return new_list;
  } else {
    new_list->prev=attach_to;
    attach_to->next=new_list;
    return list;
  }
}

EList * e_list_insert(EList * head, EList * before, void * data)
{
  EList * n=(EList *)malloc(sizeof(EList));

  n->data=data;
  n->prev=(before!=NULL)?(before->prev):(NULL);
  n->next=before;
  if(before!=NULL) { before->prev=n; }

  if(n->prev!=NULL)
  {
    n->prev->next=n;
    return head;
  } else {
    return n;
  }
}

EList * e_list_remove(EList * list, void * data)
{
  EList * n;

  for(n=list; n!=NULL; n=n->next)
  {
    if(n->data==data)
    {
      return e_list_remove_link(list, n);
    }
  }

  return list;
}

/* Warning */
/* link MUST be part of list */
EList * e_list_remove_link(EList * list, EList * link)
{
#ifndef SLOW_AND_STEADY
  if(!link)
    return list;
  if(link->next)
    link->next->prev = link->prev;
  if(link->prev)
    link->prev->next = link->next;

  if(link == list)
    list = link->next;
  link->prev = link->next = NULL;
#else /* SLOW_AND_STEADY */
  EList * n = NULL;

  for(n=list; n!=NULL; n=n->next)
  {
    if(n==link)
    {
      if(n->next!=NULL)
      { n->next->prev=n->prev; }

      if(n->prev!=NULL)
      {
        n->prev->next=n->next;
      } else {
        if(n->next!=NULL)
        { n->next->prev=NULL; return n->next; } else { return NULL; }
      }

      return list;
    }
  }

#endif
  return list;
}

int e_list_length(EList * list)
{
  int retval=0;
  EList * n=list;

  for(n=list; n!=NULL; n=n->next)
  { retval++; }

  return retval;
}

EList * e_list_copy(EList * list)
{
  EList * n;
  EList * copy=NULL;

  for(n=list; n!=NULL; n=n->next)
  {
    copy=e_list_append(copy, n->data);
  }

  return copy;
}

void e_list_free_1(EList * list)
{ free(list); }

void e_list_free(EList * list)
{
  EList * n=list;

  while(n!=NULL)
  {
    EList * next=n->next;
    free(n);
    n=next;
  }
}

EList * e_list_find_custom(EList * list, void * data, EListCompFunc comp)
{
	EList * l;
	for (l = list; l; l = l->next)
		if(comp(l->data, (const void *)data) == 0)
			return l;

	return NULL;
}

