//debug.h
#ifndef __DEBUG_H__
#define __DEBUG_H__

#include <stdio.h>

#define DBG_CORE 1
#define DBG_MOD 1

#ifdef __cplusplus
extern "C"
{
#endif

//#define eb_debug(type, format, args...) if(type) {EB_DEBUG(__FUNCTION__, __FILE__, __LINE__, format, ##args);}

#define eb_debug(cond, format, args...) if(cond) { fprintf(stderr, format, ##args); }

#ifdef __STDC__
int EB_DEBUG(const char *func, char *file, int line, char *fmt, ...);
#else
int EB_DEBUG(const char *func, char *file, int line, char *fmt, va_alist);
#endif

#ifdef __cplusplus
}  /* end extern "C" */
#endif

#endif // __DEBUG_H__
