/***************************************************************************
                          debug.c - Debugging code
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdarg.h>


#ifdef __STDC__
int EB_DEBUG(const char *func, char *file, int line, char *fmt, ...)
#else
int EB_DEBUG(const char *func, char *file, int line, char *fmt, va_alist)
        char *fmt;
        va_dcl
#endif
{
        va_list ap;
        static int indent=0;

#ifdef __STDC__
        va_start(ap, fmt);
#else
        va_start(ap);
#endif
        if(fmt && fmt[0]=='>')
                indent++;

        fprintf(stderr, "%*.*s%s[%i]:%s - ", indent, indent, " ", file, line, func);
        vfprintf(stderr, fmt, ap);
        fflush(stderr);
        va_end(ap);

        if(fmt && fmt[0]=='<')
                indent--;
        if(indent<0)
                indent=0;
        return(0);
}
