// contactlist.h

#ifndef __CONTACTLIST_H__
#define __CONTACTLIST_H__

#include <stdio.h>
#include <sys/time.h>
#include "registry.h"
#include "stringmap.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  EB_ACCOUNT_OFFLINE=0,
  EB_ACCOUNT_ONLINE=1,
  EB_ACCOUNT_AWAY=2
} EB_ACCOUNT_STATUS;


typedef struct _eb_local_account {
  struct _eb_service * service; // yuck - can't use the typedef cause it's later on
  char * handle;
  char * service_name; // used when remapping service modules among other things
  int connected; // connection in progress
  int ready; // ready to add/remove accounts / send/receive messages / etc
  char * status_string;
  void * protocol_data;
  eb_registry_key * config_key;
  EList * buddies;
  EList * group_chats;

  int locked; // reference count for ongoing translations - if you have callback data pointing
              // at this beastie, increment the ref counter.
} eb_local_account;


typedef struct _eb_group {
  char * name;
  EList * contacts; // of type eb_contact
  eb_registry_key * config_key;

  int locked;
} eb_group;

typedef struct _eb_contact {
  char * name;
  char * default_service;
  eb_group * group;
  eb_registry_key * config_key;
  eb_string_map attribs;
  EList * accounts; // of type eb_account
  char * ignore; // NULL if not ignored
  time_t next_away_msg;

  int logfile;
  time_t log_begins;
  time_t last_message;
  
  int locked;
} eb_contact;

typedef struct _eb_account {
  char * handle;
  eb_local_account * buddy_of;
  eb_contact * contact;
  eb_registry_key * config_key;
  void * protocol_data;
  EB_ACCOUNT_STATUS status;
  char * status_string;
  int blocked;

  int locked;
} eb_account;

void load_contact_list(void);

void map_orphaned_buddies(void);

extern EList * groups; // of type eb_group

#ifdef __cplusplus
}
#endif

#endif // __CONTACTLIST_H__
