/***************************************************************************
               contactlist.c - contact list loading and mapping
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "elist.h"

#include "contactlist.h"
#include "accounts.h"
#include "registry.h"
#include "util.h"
#include "gui_comms.h"

eb_group * load_group(eb_registry_key * key);
eb_contact * load_contact(eb_group * group, eb_registry_key * key);
eb_account * load_account(eb_contact * contact, eb_registry_key * key);

EList * groups;

void load_contact_list(void)
{
  eb_registry_key * listkey=eb_get_key(registry, "contact_list");
  EList * n;

  for(n=listkey->subkeys; n!=NULL; n=n->next)
  {
    eb_registry_key * thisgroup=(eb_registry_key *)n->data;

    groups=e_list_append(groups, load_group(thisgroup));
  }
}

eb_group * load_group(eb_registry_key * key)
{
  EList * n;
  eb_group * group=(eb_group *)malloc(sizeof(eb_group));

  group->name=eb_unescape_reg_key_name(key->name);
  group->contacts=NULL;
  group->config_key=key;
  group->locked=0;

  for(n=key->subkeys; n!=NULL; n=n->next)
  {
    eb_registry_key * thiscontact=(eb_registry_key *)n->data;

    group->contacts=e_list_append(group->contacts, load_contact(group, thiscontact));
  }

  return group;
}

eb_contact * load_contact(eb_group * group, eb_registry_key * key)
{
  EList * n;
  eb_contact * contact=(eb_contact *)malloc(sizeof(eb_contact));

  contact->name=eb_unescape_reg_key_name(key->name);
  contact->default_service=(char *)strdup(eb_get_value(key, "default_service"));
  contact->group=group;
  contact->accounts=NULL;
  contact->config_key=key;
  contact->attribs=NULL;
  contact->next_away_msg=0;
  contact->last_message=0;
  contact->log_begins=0;
  contact->logfile=0;
  contact->ignore=NULL;
  
  if(eb_get_value(key, "ignore")[0]=='1')
  { contact->ignore=strdup(eb_get_value(key, "ignore_message")); }

  contact->locked=0;
  
  for(n=key->subkeys; n!=NULL; n=n->next)
  {
    eb_registry_key * thisaccount=(eb_registry_key *)n->data;
    eb_account * accobj;
    
    if(!strcmp(thisaccount->name, "ui_data")) { continue; }
    
    accobj=load_account(contact, thisaccount);

    if(accobj==NULL) { continue; }
    contact->accounts=e_list_append(contact->accounts, accobj);
  }

  return contact;
}

eb_account * load_account(eb_contact * contact, eb_registry_key * key)
{
  EList * n;
  eb_account * account=(eb_account *)malloc(sizeof(eb_account));
  char * service;
  char * buddy_of;

  account->handle=(char *)strdup(eb_get_value(key, "handle"));
  account->contact=contact;
  account->protocol_data=NULL;
  account->status=EB_ACCOUNT_OFFLINE;
  account->status_string=strdup("(Offline)");
  account->buddy_of=NULL;
  account->config_key=key;
  account->blocked=0;
  account->locked=0;

  service=eb_get_value(key, "service");
  buddy_of=eb_get_value(key, "buddy_of");

  for(n=local_accounts; n!=NULL; n=n->next)
  {
    eb_local_account * acc=(eb_local_account *)n->data;

    if(!strcmp(acc->service_name, service) && !strcmp(acc->handle, buddy_of))
    { account->buddy_of=acc; break; }
  }
  if(account->buddy_of==NULL)
  {
    printf("WARNING - CANNOT FIND LOCAL ACCOUNT FOR %s(%s) in %s\n",
      eb_get_value(key, "handle"), service ? service : "no service!", key ? key->name : "(no key!)");
    return NULL;
  } else {
    account->buddy_of->buddies=e_list_append(account->buddy_of->buddies, account);

    if(account->buddy_of->service->sc->setup_buddy_account)
    { account->buddy_of->service->sc->setup_buddy_account(account); }
  }

  return account;
}


void map_orphaned_buddies(void)
{
  EList * n;

  for(n=eb_get_key(registry, "contact_list")->subkeys; n!=NULL; n=n->next)
  {
    EList * n2;
    eb_registry_key * group=(eb_registry_key *)n->data;

    for(n2=group->subkeys; n2!=NULL; n2=n2->next)
    {
      EList * n3;
      eb_registry_key * contact=(eb_registry_key *)n2->data;

      for(n3=contact->subkeys; n3!=NULL; n3=n3->next)
      {
        eb_contact * cont=eb_get_contact(group->name, contact->name);
        eb_registry_key * acct_key=(eb_registry_key *)n3->data;

        if(eb_get_account(eb_get_value(acct_key, "buddy_of"), eb_get_value(acct_key, "service"), eb_get_value(acct_key, "handle"))==NULL)
        {
          eb_local_account * buddy_of=eb_get_local_account(eb_get_value(acct_key, "buddy_of"), eb_get_value(acct_key, "service"));
          eb_account * acct=load_account(cont, acct_key);

          if(acct!=NULL)
          {
            char * added_command[]={"add_account", group->name, contact->name, buddy_of->handle, buddy_of->service_name, acct->handle};

            cont->accounts=e_list_append(cont->accounts, acct);

            eb_gui_broadcast(added_command, 6);
          }
        }
      }
    }
  }
}
