// actions.h
#ifndef __ACTIONS_H__
#define __ACTIONS_H__

#include "elist.h"

typedef void (*eb_action_callback)(void * target);

typedef struct _eb_action
{
  eb_action_callback callback;
  char * name;
} eb_action;

#ifdef __cplusplus
extern "C" {
#endif

eb_action * eb_create_action(char * name, eb_action_callback callback);

void eb_free_action(eb_action * action);

#ifdef __cplusplus
}
#endif

#if defined(__MINGW32__) && defined(__IN_PLUGIN__)
__declspec(dllimport) EList * eb_group_actions;
__declspec(dllimport) EList * eb_contact_actions;
__declspec(dllimport) EList * eb_buddy_actions;
__declspec(dllimport) EList * eb_general_actions;
#else
extern EList * eb_group_actions;
extern EList * eb_contact_actions;
extern EList * eb_buddy_actions;
extern EList * eb_general_actions;
#endif


#endif // __ACTIONS_H__
