/***************************************************************************
                    accounts.c - Local account management
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "elist.h"

#include "dialog.h"
#include "services.h"
#include "accounts.h"
#include "registry.h"
#include "prefs.h"
#include "util.h"

EList * local_accounts;

void load_local_accounts(void)
{
  EList * n;
  eb_registry_key * acctlist;

  acctlist=eb_get_key(registry, "local_accounts");

  for(n=acctlist->subkeys; n!=NULL; n=n->next)
  {
    eb_registry_key * acctkey=(eb_registry_key *)n->data;
    eb_local_account * new_acct;

    new_acct=(eb_local_account *)malloc(sizeof(eb_local_account));

    new_acct->config_key=acctkey;
    new_acct->handle=(char *)strdup(eb_get_value(acctkey, "handle"));
    new_acct->service_name=(char *)strdup(eb_get_value(acctkey, "service"));
    new_acct->protocol_data=NULL;
    new_acct->service=&dummy_service;
    new_acct->buddies=NULL;
    new_acct->group_chats=NULL;
    new_acct->connected=0;
    new_acct->ready=0;
    new_acct->status_string=strdup("Offline");
    new_acct->locked=0;

    local_accounts=e_list_append(local_accounts, new_acct);
  }

  map_orphaned_accounts();
}

void map_orphaned_accounts(void)
{
  EList * n;

  for(n=local_accounts; n!=NULL; n=n->next)
  {
    eb_local_account * account=(eb_local_account *)n->data;

    if(account->service==&dummy_service)
    {
      EList * n2;

      for(n2=services; n2!=NULL; n2=n2->next)
      {
        eb_service * service=(eb_service *)n2->data;

        if(!strcmp(account->service_name, service->name))
        {
          EList * n;

          account->service=service;
          if(service->sc->setup_local_account)
          {
            service->sc->setup_local_account(account);
          }

          for(n=account->buddies; n!=NULL; n=n->next)
          {
            eb_account * buddy=(eb_account *)n->data;

            if(service->sc->setup_buddy_account)
            { service->sc->setup_buddy_account(buddy); }
          }
        }
      }
    }
  }
}
