/***************************************************************************
                           vpa.c - The Virtual PA
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "globals.h"
#include "plugin.h"
#include "plugin_api.h"
#include "prefs.h"
#include "contacts.h"

#define VPA_INIT	0
 
typedef struct _vpa_state
{
  int state;
} vpa_state;

static char * name;

void eb_vpa_init(void)
{
  eb_pref_page * parent=eb_make_pref_page(features, "vpa", "Virtual PA");
  eb_pref_page * page;
  
  return;
  /*
  
  eb_add_component(parent, EB_PREF_LABEL, "lbl", "The intelligent alternative to an away message", registry, "tmp/dump", NULL, NULL);  
eb_add_option_strings(parent, "name", "How should the Virtual PA refer to you?", 
registry, "config/vpa/name", NULL, NULL);  eb_put_default(registry, 
"config/vpa/name", "This user");
*/ 
   
}

static char * sent_msg(char * msg, void * data)
{ disengage(((eb_account *)data))->contact);}

static char * got_msg(char * msg, void * data)
{
  eb_account * acc=(eb_account *)data;
  
  vpa_state * st=(vpa_state *)eb_string_map_get(acc->contact->attribs, "vpa");

  name=eb_get_value(registry, "config/vpa/name");
    
  if(st==NULL)
  {
    st=(vpa_state *)malloc(sizeof(vpa_state));
    eb_string_map_put(acc->contact->attribs, "vpa", st);
    st->state=VPA_INIT;
  }
  
  if(st->state==VPA_INIT)
  {
    if(acc->buddy_of->service->sc->send_im)
    {
      char * m=(char *)malloc(128+strlen(name));
      sprintf(m, "%s is currently unavailable (%s). This is the Everybuddy virtual PA.\n"
      "Just carry on typing to leave a message. If it's urgent, say so, and I can try other "
      "means of contact", name, away_short);
      m=acc->buddy_of->service->sc->send_im(acc, m);
      if(m!=NULL) { free(m); }
      
      st->state=VPA_GREETED;
    }
  }

  free(msg);
  return NULL;
}


static void disengage(eb_contact * c)
{
  vpa_state * st=(vpa_state *)eb_string_map_get(c->attribs, "vpa");
  if(st!=NULL)
  {
    free(st);
    eb_string_map_remove_value(st);
  }
}
