/***************************************************************************
                             toc.c - AIM and ICQ
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "elist.h"
#include "plugin_api.h"
#include "prefs.h"
#include "dialog.h"
#include "gui_comms.h"
#include "message_parse.h"
#include "util.h"

#include "libtoc.h"


#define GET_LAD(x) ((eb_toc_lad *)((x)->protocol_data))
#define GET_ELA(x) ((eb_local_account *)((x)->account))

int eb_toc_init(void);
int eb_toc_finish(void);
void eb_toc_login(eb_local_account * ela);
void eb_toc_logout(eb_local_account * ela);
void eb_toc_disconnect (toc_conn * conn);

eb_plugin_info toc_LTX_plugin_info={"AIM/ICQ via TOC", "Torrey Searle's libtoc", "Who knows?", "Who cares?", eb_toc_init, eb_toc_finish};

eb_service_callbacks toc_cb;
eb_service eb_toc_aim_service={"AIM", "AOL IM via TOC", &toc_cb, SERVICE_CAN_GROUPCHAT|SERVICE_CAN_NAME_CHAT, "#000088", NULL, NULL, NULL, NULL};
eb_service eb_toc_icq_service={"ICQ", "ICQ via TOC", &toc_cb, SERVICE_CAN_GROUPCHAT|SERVICE_CAN_NAME_CHAT|SERVICE_CAN_OFFLINE, "#008800", NULL, NULL, NULL, NULL};

// eb_toc_init() and eb_toc_finish() are right at the bottom of the file so I don't need
// to prototype them - am I lazy or what?

EList * toc_accounts=NULL;

typedef struct _eb_toc_lad {
  toc_conn * conn;
  eb_pref_page * prefs;
  int fd_tag;
  int away;
} eb_toc_lad;

eb_account * eb_toc_get_account(eb_local_account * ela, char * handle)
{
  EList * n;

  for(n=ela->buddies; n!=NULL; n=n->next)
  {
    eb_account * acc=(eb_account *)n->data;
    char * s1=strdup(aim_normalize(handle));
    char * s2=strdup(aim_normalize(acc->handle));

    if(!strcmp(s1, s2)) { return acc; }

    free(s1);
    free(s2);
  }

  return NULL;
}

eb_group_chat * eb_toc_get_chat(eb_local_account * ela, char * id)
{
  EList * n;

  for(n=ela->group_chats; n!=NULL; n=n->next)
  {
    eb_group_chat * chat=(eb_group_chat *)n->data;
    if(!strcmp((char *)chat->protocol_data, id)) { return chat; }
  }

  return NULL;
}

void eb_toc_callback(void * data, int fd, int conditions)
{
  toc_callback((toc_conn *)data);
}

void eb_toc_set_state(eb_local_account * ela, char * state)
{
  eb_toc_lad * lad=GET_LAD(ela);
  char * st_str = NULL;

  if(!strcmp(state, "Offline"))
  {
    eb_toc_logout(ela);
    return;
  }
  else
  {
    /* Check if we are connected yet */
    if (!ela->connected)
    {
      /* connect to the server */
      eb_toc_login(ela);
    }
    else if (ela->ready)
    {
      /* Only set the away message if the connection is ready */

      if(!strcmp(state, "Online"))
      {
	if (lad->away)
	{
	  toc_set_away(lad->conn, NULL);
	  lad->away = 0;
	}
      }
      else
      {
	/* when changing the away message, need to change to not away first */
        if (lad->away)
	{
	  toc_set_away(lad->conn, NULL);
	}
	else
	{
	  lad->away = 1;
	}

	if(!strcmp(state, "Away"))
	{
	  toc_set_away(lad->conn, "This user is away.");
	}
	else
	{
	  toc_set_away(lad->conn, state);
	}
      }

      free(ela->status_string);
      ela->status_string = strdup(state);
      eb_local_account_update(ela);
    }
  }
}

void eb_toc_signon_cb(void * data, toc_conn * conn)
{
  eb_local_account * ela = data;

  eb_toc_lad * lad = GET_LAD(ela);

  if (lad == NULL)
  {
    if (conn)
      free(conn);
    return;
  }

  if (ela->ready || lad->conn)
  {
    // Extra connect callback, probably from a previous attempt
    if (conn)
      free(conn);
    return;
  }

  if (conn == NULL)
  {
    eb_show_error("Could not log into TOC server. Check your preferences and try again.", "Connection failed");
    ela->connected = ela->ready = 0;
    eb_local_account_update(ela);
    return;
  }

  lad->conn = conn;

  lad->conn->account = ela;

  lad->fd_tag = eb_input_add(lad->conn->fd, EB_INPUT_READ|EB_INPUT_EXCEPTION, eb_toc_callback, lad->conn);

  ela->ready = 1;
  eb_toc_set_state(ela, "Online");
}

void eb_toc_login(eb_local_account * ela)
{
  eb_toc_lad * lad = GET_LAD(ela);

  if (atoi(eb_get_value(ela->config_key, "excl_soa")))
  { return; }

  ela->connected = 1;
  ela->ready = 0;
  eb_local_account_update(ela);

  if (lad->conn != NULL)
  {
    eb_toc_disconnect(lad->conn);
  }

  toc_signon(ela->handle, eb_get_value(ela->config_key, "password"),
    eb_get_value(ela->config_key, "toc/server"), atoi(eb_get_value(ela->config_key, "toc/port")),
    eb_get_value(ela->config_key, "user_info"), eb_toc_signon_cb, ela);
}

void eb_toc_logout(eb_local_account * ela)
{
  EList * en;
  eb_toc_lad * lad = GET_LAD(ela);

  if (!ela->connected)
    return;

  for (en = ela->buddies; en != NULL; en = en->next)
  {
    eb_account * acc = (eb_account *)en->data;
    if (acc->status != EB_ACCOUNT_OFFLINE)
    {
      free(acc->status_string);
      acc->status_string = strdup("Offline");
      acc->status = EB_ACCOUNT_OFFLINE;
      eb_buddy_update_status(acc);
      eb_buddy_logout(acc);
    }
  }

  free(ela->status_string);
  ela->status_string = strdup("Offline");
  ela->ready = ela->connected = 0;
  eb_local_account_update(ela);
  if (lad->conn != NULL)
  {
    eb_toc_disconnect(lad->conn);
  }
  lad->away=0;
}

void eb_toc_setup_local_account(eb_local_account * ela)
{
  eb_toc_lad * lad=(eb_toc_lad *)malloc(sizeof(eb_toc_lad));
  char * tmp;
  char * tmp2;

  lad->conn=NULL;
  lad->away=0;
  ela->protocol_data=lad;

  eb_put_default(ela->config_key, "user_info", "Visit the <a href=\"http://www.everybuddy.com/\">Everybuddy website</a>");
  eb_put_default(ela->config_key, "toc/server", "toc.oscar.aol.com");
  eb_put_default(ela->config_key, "toc/port", "22");

  tmp=(char *)malloc(strlen(ela->handle)+16);
  tmp2=(char *)malloc(strlen(ela->handle)+16);
  sprintf(tmp, "%s (%s)", ela->handle, ela->service_name);
  sprintf(tmp2, "%s_%s", ela->handle, ela->service_name);
  lad->prefs=eb_make_pref_page(account_prefs, tmp2, tmp);
  free(tmp);
  free(tmp2);

  eb_add_component(lad->prefs, EB_PREF_TOGGLE, "excl_soa", "Exclude from \"Sign On All\"", ela->config_key, "excl_soa", NULL, NULL);

  eb_add_component(lad->prefs, EB_PREF_PASSWORD, "password", "Password:", ela->config_key, "password", NULL, NULL);
  eb_add_component(lad->prefs, EB_PREF_STRING, "toc_server", "TOC Server:", ela->config_key, "toc/server", NULL, NULL);
  eb_add_component(lad->prefs, EB_PREF_STRING, "toc_port", "TOC Port:", ela->config_key, "toc/port", NULL, NULL);

  toc_accounts=e_list_append(toc_accounts, ela);
}

void eb_toc_release_local_account(eb_local_account * ela)
{
  eb_destroy_pref_page(GET_LAD(ela)->prefs);
  free(ela->protocol_data);

  toc_accounts=e_list_remove(toc_accounts, ela);
}

char * eb_toc_send_im(eb_account * dest, char * msg)
{
  eb_toc_lad * lad=GET_LAD(dest->buddy_of);
  char * disp;
  char * send;
  char * encoded;

  if(!dest->buddy_of->ready)
  {
    eb_show_error("Cannot send message from an offline account", "TOC error");
    return NULL;
  }

  send=eb_filter_string(EB_PREFILTER_OUT, msg, dest);
  if(send==NULL) { return NULL; }
  disp=strdup(send);
  send=eb_filter_string(EB_POSTFILTER_OUT, send, dest);
  if(send==NULL) { return NULL; }

  encoded=eb_utf2ascii(send);
  toc_send_im(lad->conn, dest->handle, encoded);

  free(send);
  free(encoded);

  return disp;
}

void eb_toc_send_data_message(eb_account * to, char * filename, char * contenttype, char * disposition, int reported_length)
{
  if(!strcmp(disposition, "inline") && reported_length<5500)
  {
    char * buf[5];
    int a, num_msg;
    
    for(a=0; a<5; a++) { buf[a]=(char *)malloc(2048); }
    
    eb_package_inlined_data(filename, contenttype, reported_length, 1900,  buf, &num_msg);
    
    for(a=0; a<num_msg; a++)
    {
      toc_send_im(GET_LAD(to->buddy_of)->conn, to->handle, buf[a]);
    }
  
    for(a=0; a<5; a++) { free(buf[a]); }
    
    eb_sent_inline_data_message(to, filename, contenttype);
    
    return;
  }
  
  eb_notify_3rdperson(to->contact, "<font color=red><i>IRC cannot yet send large or non-inlined data messages");
}

void eb_toc_add_user(eb_local_account * ela, eb_account * buddy)
{
  if(!ela->ready)
  {
    eb_show_error("Can't add an account to an offline account", "TOC error");
    free(buddy->handle);
    free(buddy->status_string);
    free(buddy);
    return;
  }

  toc_add_buddy(GET_LAD(ela)->conn, buddy->handle, buddy->contact->group->name);

  eb_add_account(buddy->contact, ela, buddy);
}

void eb_toc_del_user(eb_account * buddy)
{
  if(!buddy->buddy_of->ready)
  {
    eb_show_error("Can't delete an account from an offline account", "TOC error");
    return;
  }

  toc_remove_buddy(GET_LAD(buddy->buddy_of)->conn, buddy->handle, buddy->contact->group->name);

  eb_destroy_inlined_data_state((eb_inlined_data_state *)buddy->protocol_data);
  
  eb_del_account(buddy);
}

void eb_toc_set_away(eb_local_account * ela, char * short_msg, char * long_msg)
{
  eb_toc_set_state(ela, long_msg);
}

void eb_toc_unset_away(eb_local_account * ela)
{
  eb_toc_set_state(ela, "Online");
}

void eb_toc_join_group_chat(eb_local_account * ela, char * name)
{
  toc_chat_join(GET_LAD(ela)->conn, name);
}

void eb_toc_group_chat_invite(eb_group_chat * chat, char * user)
{
  toc_invite(GET_LAD(chat->account)->conn, (char *)chat->protocol_data, user, "An Everybuddy user is inviting you into this chatroom");
}

char * eb_toc_group_chat_send(eb_group_chat * chat, char * msg)
{
  toc_chat_send(GET_LAD(chat->account)->conn, (char *)chat->protocol_data, msg);

  return msg;
}

void eb_toc_leave_group_chat(eb_group_chat * chat)
{
  toc_chat_leave(GET_LAD(chat->account)->conn, (char *)chat->protocol_data);

  eb_destroy_group_chat(chat);
}

// *******************************************************************************
// libtoc callbacks

void eb_toc_new_user (toc_conn * conn, char * groupname, char * user)
{
  eb_account * acc=eb_toc_get_account(GET_ELA(conn), user);

  if(acc==NULL)
  {
    eb_group * group=eb_get_group(groupname);
    eb_contact * cont;

    if(group==NULL)
    { group=eb_add_group(groupname); }

    cont=eb_get_contact(groupname, user);
    if(cont==NULL)
    { cont=eb_add_contact(group, user); }

    acc=(eb_account *)malloc(sizeof(eb_account));
    acc->handle=strdup(user);
    acc->status_string=strdup("");
    acc->contact=cont;
    eb_add_account(cont, GET_ELA(conn), acc);
  }

  if(strcmp(acc->contact->group->name, groupname)) // && eb_get_contact(groupname, acc->contact->name) // if they differ
  {
    toc_remove_buddy(conn, user, groupname);
    toc_add_buddy(conn, user, acc->contact->group->name);
  }
}

int  eb_toc_begin_file_receive( char * filename, unsigned long size )
{
return 0; // keep the compiler happy
}

void eb_toc_update_file_status( int tag, unsigned long progress )
{
}

void eb_toc_complete_file_receive( int tag )
{
}

void eb_toc_im_in(toc_conn  * conn, char * user, char * message )
{
  eb_local_account * ela=GET_ELA(conn);
  eb_account * acc=eb_toc_get_account(ela, user);
  char * filtered;

  if(acc==NULL)
  {
    eb_group * group=eb_get_group("Unknown");
    eb_contact * cont;

    if(group==NULL)
    { group=eb_add_group("Unknown"); }

    cont=eb_get_contact("Unknown", user);
    if(cont==NULL)
    { cont=eb_add_contact(group, user); }

    acc=(eb_account *)malloc(sizeof(eb_account));
    acc->handle=strdup(user);
    acc->status_string=strdup("");
    acc->contact=cont;
    eb_toc_add_user(ela, acc);
  }
  
  if(!strncmp(message, "EB+]#[", 6)) // inlined transfer
  {
    if(eb_handle_inlined_data(acc, message, strlen(message),
    (eb_inlined_data_state **)&(acc->protocol_data))==0)
    { return; }
  }

  filtered=eb_ascii2utf(message);
  filtered=eb_filter_string(EB_FILTER_IN, filtered, acc);
  if(filtered==NULL) { return; }

  eb_incoming_message(acc, filtered);
  free(filtered);
}

void eb_toc_chat_im_in(toc_conn  * conn, char * id, char * user, char * message )
{
  eb_group_chat * chat=eb_toc_get_chat(GET_ELA(conn), id);
  char * stmp;

  if(chat==NULL)
  {
    eb_show_error("Closing martian chat - this should not happen.\nPlease report it as a bug to meredydd@everybuddy.com", "TOC error");
    toc_chat_leave(conn, id);
    return;
  }

  stmp=strdup(aim_normalize(user));

  if(strcmp(stmp, aim_normalize(chat->account->handle)))
  { eb_group_chat_message(chat, user, message); }
  free(stmp);
}

void eb_toc_update_user_status (toc_conn * conn, char * user, int online, time_t idle, int evil, int unavailable )
{
  eb_local_account * ela=GET_ELA(conn);
  eb_account * acc;
  char buf[64];
  char buf2[64];
  int do_login = 0;
  int do_logout = 0;

  if (ela == NULL)
  {
    printf("Martian buddy update (%s)\n", user);
    return;
  }

  acc = eb_toc_get_account(ela, user);
  if (acc == NULL)
  {
    acc = eb_add_account_plus("Unknown", user, ela, user);
  }

  if (acc->status == EB_ACCOUNT_OFFLINE)
  {
    do_login = 1;
  }

  free(acc->status_string);
  if (online)
  {
    if (unavailable)
    {
      acc->status = EB_ACCOUNT_AWAY;
      sprintf(buf, "Away");
    }
    else
    {
      acc->status = EB_ACCOUNT_ONLINE;
      sprintf(buf, "");
    }

    if (idle > 0)
    {
      int mins = (time(NULL) - idle) / 60;
      strcat(buf, "(");

      if (mins / (60 * 24))
      {
	sprintf(buf2, "%d:", mins / (60 * 24));
	strcat(buf, buf2);
	mins %= (60 * 24);
      }

      sprintf(buf2, "%d:%02d)", mins / 60, mins % 60);
      strcat(buf, buf2);
    }

    if (evil)
    {
      sprintf(buf2, " [%d%%]", evil);
      strcat(buf, buf2);
    }

    acc->status_string = strdup(buf);
  }
  else
  {
    acc->status = EB_ACCOUNT_OFFLINE;
    acc->status_string = strdup("Offline");
    do_login = 0;
    do_logout = 1;
  }

  if (do_login)
  {
    eb_buddy_login(acc);
  }
  eb_buddy_update_status(acc);
  if (do_logout)
  {
    eb_buddy_logout(acc);
  }
}

void eb_toc_error_message(char * message)
{
  eb_show_error(message, "TOC error");
}

void eb_toc_disconnect (toc_conn * conn)
{
  eb_local_account * ela=GET_ELA(conn);
  eb_toc_lad * lad;
  EList * n;

  if (conn == NULL)
    return;

  if (ela == NULL)
  {
  } else {
    lad=GET_LAD(ela);

    lad->conn = NULL; /* Make sure that logout doesn't try to call us */

    if(ela->connected)
    {
      eb_toc_logout(ela);
    }
    eb_input_remove(lad->fd_tag);
  }

  toc_signoff(conn);
  free(conn);
}

void eb_toc_join_ack (toc_conn * conn, char * id, char * name)
{
  eb_local_account * ela=GET_ELA(conn);
  eb_group_chat * chat=eb_create_group_chat(ela);

  chat->title=strdup(name);
  chat->protocol_data=strdup(id);
  eb_announce_group_chat(chat);
}

void eb_toc_chat_invite (toc_conn * conn, char * id, char * name,
		      char * sender, char * message )
{
  toc_chat_accept(conn, id);
}

void eb_toc_chat_update_buddy (toc_conn * conn, char * id,
		                             char * user, int inside )
{
  eb_group_chat * chat=eb_toc_get_chat(GET_ELA(conn), id);
  char * buf;

  if(chat==NULL)
  {
    eb_show_error("Closing martian chat - this should not happen.\nPlease report it as a bug to meredydd@everybuddy.com", "TOC error");
    toc_chat_leave(conn, id);
    return;
  }

  if(chat->announced)
  {
    buf=(char *)malloc(strlen(user)+64);
    sprintf(buf, "<font color=#666666><i><b>%s</b> has %s", user, inside?"joined":"left");
    eb_group_chat_3rdperson(chat, buf);
    free(buf);
  }

  if(inside)
  {
    eb_group_chat_joined(chat, user);
  } else {
    eb_group_chat_left(chat, user);
  }
}

void eb_toc_file_offer ( toc_conn * conn, char * nick, char * ip, short port,
		                      char * cookie, char * filename )
{
}

void eb_toc_user_info (toc_conn  * conn, char * user, char * message )
{
}

// *******************************************************************************
// General plugin stuff here



int eb_toc_init(void)
{
  EList * states=NULL;

  memset(&toc_cb, 0, sizeof(eb_service_callbacks));

  states=e_list_append(states, strdup("Online"));
  states=e_list_append(states, strdup("Away"));
  states=e_list_append(states, strdup("Offline"));

  eb_toc_aim_service.states=states;
  eb_toc_icq_service.states=states;

  toc_cb.login=eb_toc_login;
  toc_cb.logout=eb_toc_logout;
  toc_cb.send_im=eb_toc_send_im;
  toc_cb.send_data_message=eb_toc_send_data_message;
  toc_cb.setup_local_account=eb_toc_setup_local_account;
  toc_cb.release_local_account=eb_toc_release_local_account;
  toc_cb.set_current_state=eb_toc_set_state;
  toc_cb.add_user=eb_toc_add_user;
  toc_cb.del_user=eb_toc_del_user;
  toc_cb.set_away=eb_toc_set_away;
  toc_cb.unset_away=eb_toc_unset_away;
  toc_cb.join_group_chat=eb_toc_join_group_chat;
  toc_cb.leave_group_chat=eb_toc_leave_group_chat;
  toc_cb.group_chat_send=eb_toc_group_chat_send;
  toc_cb.group_chat_invite=eb_toc_group_chat_invite;

  toc_new_user=eb_toc_new_user;
  toc_begin_file_recieve=eb_toc_begin_file_receive;
  toc_update_file_status=eb_toc_update_file_status;
  toc_complete_file_recieve=eb_toc_complete_file_receive;
  toc_im_in=eb_toc_im_in;
  toc_chat_im_in=eb_toc_chat_im_in;
  update_user_status=eb_toc_update_user_status;
  toc_disconnect=eb_toc_disconnect;
  toc_chat_invite=eb_toc_chat_invite;
  toc_join_ack=eb_toc_join_ack;
  toc_chat_update_buddy=eb_toc_chat_update_buddy;
  toc_file_offer=eb_toc_file_offer;
  toc_user_info=eb_toc_user_info;
  toc_error_message=eb_toc_error_message;

  eb_load_service(&eb_toc_aim_service);
  eb_load_service(&eb_toc_icq_service);

  return 0;
}

int eb_toc_finish(void)
{
  // will this ever run?
  return 0;
}
