/*
 * libtoc
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef __LIB_TOC__
#define __LIB_TOC__

#include <stdio.h>
#include <time.h>
#include "elist.h"

typedef struct _toc_conn
{
    int fd;
    int seq_num;
    void * account;
    char server[255];
    short port;
} toc_conn;

typedef struct _toc_file_conn
{
	char header1[7];
	char header2[2048];
	int  fd;
	unsigned long amount;
	FILE * file;
	int  handle;
	int  progress;
} toc_file_conn;

extern void (*toc_new_user)(toc_conn * conn, char * group, char * handle);
extern int  (*toc_begin_file_recieve)( char * filename, unsigned long size );
extern void (*toc_update_file_status)( int tag, unsigned long progress );
extern void (*toc_complete_file_recieve)( int tag );
extern void (*toc_im_in)(toc_conn  * conn, char * user, char * message );
extern void (*toc_chat_im_in)(toc_conn  * conn, char * id, char * user, char * message );
extern void (*update_user_status)(toc_conn * conn, char * user, int online, time_t idle, int evil, int unavailable );
extern void (*toc_error_message)(char * message);
extern void (*toc_disconnect)(toc_conn * conn);
extern void (*toc_chat_invite)(toc_conn * conn, char * id, char * name,
		      char * sender, char * message );
extern void (*toc_join_ack)(toc_conn * conn, char * id, char * name);
extern void (*toc_chat_update_buddy)(toc_conn * conn, char * id,
		                             char * user, int online );
extern void (*toc_file_offer)( toc_conn * conn, char * nick, char * ip, short port,
		                      char * cookie, char * filename );

extern void (*toc_user_info)(toc_conn  * conn, char * user, char * message );

void toc_callback( toc_conn * conn );
void toc_signon( char * username, char * password,
		char * server, short port, char * info, void (*callback)(void * data, toc_conn * conn), void * data);
void toc_send_keep_alive( toc_conn * conn );
void toc_signoff( toc_conn * conn );
void toc_send_im( toc_conn * conn, char * username, char * message );
void toc_get_info( toc_conn * conn, char * user );
void toc_add_buddies( toc_conn * conn, char * group, EList * list );
void toc_add_buddy( toc_conn * conn, char * user, char * group );
void toc_set_idle( toc_conn * conn, int idle );
void toc_set_away( toc_conn * conn, char * message);
void toc_invite( toc_conn * conn, char * id, char * buddy, char * message );
void toc_chat_join( toc_conn * conn, char * chat_room_name );
void toc_chat_send( toc_conn * conn, char * id, char * message);
void toc_chat_leave( toc_conn * conn, char * id );
void toc_chat_accept( toc_conn * conn, char * id);
void toc_file_accept( toc_conn * conn, char * nick, char * ip, short port,
		                      char * cookie, char * filename );
void toc_file_cancel( toc_conn * conn, char * nick, char * cookie );
void toc_talk_accept( toc_conn * conn, char * nick, char * ip, short port,
					  char * cookie );
void toc_remove_buddy( toc_conn * conn, char * user, char * group );

char *aim_normalize(char *s);


#endif
