#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "elist.h"
#include "plugin_api.h"

#include "libtoc.h"


#define GET_LAD(x) ((eb_toc_lad *)(x))


void eb_toc_init(void);
void eb_toc_finish(void);

eb_plugin_info toc_LTX_plugin_info={"AIM/ICQ via TOC", "Torrey Searle's libtoc", "Who knows?", "Who cares?", eb_toc_init, eb_toc_finish};

eb_service_callbacks toc_cb;
eb_service eb_toc_aim_service={"AIM", "AOL IM via TOC", &toc_cb, 0, "#000088", NULL, NULL, NULL, NULL};
eb_service eb_toc_icq_service={"ICQ", "ICQ via TOC", &toc_cb, 0, "#008800", NULL, NULL, NULL, NULL};

// eb_toc_init() and eb_toc_finish() are right at the bottom of the file so I don't need
// to prototype them - am I lazy or what?


typedef struct _eb_toc_lad {
  toc_conn * conn;
} eb_toc_lad;


void eb_toc_login(eb_local_account * ela)
{
  eb_toc_set_state(ela, "Online");
}

void eb_toc_logout(eb_local_account * ela)
{
  eb_toc_set_state(ela, "Offline");
}

void eb_toc_set_state(eb_local_account * ela, char * state)
{
  eb_toc_lad * lad=GET_LAD(ela);

  if(!strcmp(state, "Online"))
  {
    if(ela->connected) { return; }

    lad->
  }
}

void eb_toc_setup_local_account(eb_local_account * ela)
{
  eb_toc_lad * lad=(eb_toc_lad *)malloc(sizeof(eb_toc_lad));
  lad->conn=NULL;
  ela->protocol_data=lad;
}

void eb_toc_release_local_account(eb_local_account * ela)
{
  free(ela->protocol_data);
}

char * eb_toc_send_im(eb_account * dest, char * msg)
{
}

void eb_toc_add_user(eb_local_account * ela, eb_account * buddy)
{
}

void eb_toc_del_user(eb_account * buddy)
{
}

void eb_toc_init(void)
{
  EList * states;

  printf("TOC plugin init\n");
  memset(&toc_cb, 0, sizeof(eb_service_callbacks));

  states=e_list_append(states, strdup("Online"));
  states=e_list_append(states, strdup("Offline"));

  eb_toc_aim_service->states=states;
  eb_toc_icq_service->states=states;

  toc_cb.login=eb_toc_login;
  toc_cb.logout=eb_toc_logout;
  toc_cb.send_im=eb_toc_send_im;
  toc_cb.setup_local_account=eb_toc_setup_local_account;
  toc_cb.release_local_account=eb_toc_release_local_account;
  toc_cb.set_current_state=eb_toc_set_state;
  toc_cb.add_user=eb_toc_add_user;
  toc_cb.del_user=eb_toc_del_user;

  eb_load_service(&eb_toc_aim_service);
  eb_load_service(&eb_toc_icq_service);
}

void eb_toc_finish(void)
{
  // will this ever run?
}