// msn_ssl_openssl.C - implementing the MSN passport authentication with the OpenSSL
// library.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gnutls/openssl.h>

#include "msn_core.h"
#include "msn_bittybits.h"
#include "msn_interface.h"

SSL_CTX * ctx=NULL;

void get_passport(msnconn * conn, char * host, char * url, char * auth_header);

void ext_get_passport(msnconn * conn, char * auth_header)
{
  get_passport(conn, "login.passport.com", "/login2.srf", auth_header);
}

void get_passport(msnconn * conn, char * host, char * url, char * auth_header)
{
  SSL * ssl;
  int fd;
  char r1[]=" HTTP/1.1\r\nHost: ";
  char buf[2048];
  char lastc=' ';
  int pos=0;
  
  fd=ext_connect_socket(host, 443);
  if(fd<0) { msn_got_passport(conn, 0, NULL); return; }
  
  if(ctx==NULL)
  {
    SSL_load_error_strings();
    SSL_library_init();
    ctx=SSL_CTX_new(SSLv23_client_method());
  }
  ssl=SSL_new(ctx);
  
  SSL_set_fd(ssl, fd);
  SSL_connect(ssl);
  SSL_write(ssl, "GET ", 4);
  SSL_write(ssl, url, strlen(url));
  SSL_write(ssl, r1, strlen(r1));
  SSL_write(ssl, host, strlen(host));
  SSL_write(ssl, "\r\n", 2);
  SSL_write(ssl, auth_header, strlen(auth_header));
  SSL_write(ssl, "\r\n\r\n", 4);

  pos=0;
  
  while(1)
  {
    char c;
    SSL_read(ssl, &c, 1);
    buf[pos++]=c;
    putchar(c);
    
    if(c=='\n' && lastc=='\n') { buf[pos]='\0'; break; }
    if(pos==2047) { buf[2047]='\0'; break; }
    if(c!='\r') { lastc=c; }
  }
  
  if(!strncmp(buf, "HTTP/1.1 3", 10))
  {
    char * loc=msn_find_in_mime(buf, "Location");
    char * h;
    char * u;
    
    if(loc==NULL || strlen(loc)<10)
    { msn_got_passport(conn, 0, NULL); if(loc!=NULL) { delete loc; } return; }
    h=loc+8;
    u=strchr(h, '/');
    if(u==NULL) { msn_got_passport(conn, 0, NULL); return; }
    u=msn_permstring(u);
    strchr(h, '/')[0]='\0';
    
    get_passport(conn, h, u, auth_header);
    
    delete loc;
    delete u;
  } else {
    int code;
    sscanf(buf, "HTTP/1.1 %d ", &code);
    char * auth=msn_find_in_mime(buf, "Authentication-Info");
    msn_got_passport(conn, code, auth);
    if(auth) { delete auth; }
  }

  close(fd);  
  SSL_free(ssl);
}
