/***************************************************************************
                     msn.C - MSN support for EB-Lite
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <stdio.h>

#include "msn_core.h"
#include "msn_bittybits.h"
#include "msn_interface.h"

#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#ifdef __MINGW32__
#include <winsock2.h>
#else
#include <sys/socket.h>
#endif
#include <sys/stat.h>
#ifndef __MINGW32__
#include <arpa/inet.h>
#endif
#include <fcntl.h>
#ifndef __MINGW32__
#include <netinet/in.h>
#include <netdb.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "elist.h"

#include "util.h"
#include "services.h"
#include "accounts.h"
#include "prefs.h"
#include "gui_comms.h"
#include "plugin_api.h"
#include "debug.h"
#include "dialog.h"
#include "message_parse.h"

#define GET_LAD(x) ((eb_msn_local_account_data *)((x)->protocol_data))
//#define GET_BAD(x) ((eb_msn_buddy_account_data *)((x)->protocol_data))

// added by Philip for compatibility with solaris 2.5
#if HAVE_CONFIG_H
# include <config.h>
#endif
#if NEED_PROTO_GETHOSTNAME
extern "C" int gethostname(char *name, int namelen);
#endif
// end add

#define plugin_info msn_LTX_plugin_info

extern "C"
{
int msn_plugin_init();
int msn_plugin_finish();
eb_service_callbacks sc;

eb_service msn_service_info={"MSN", "Meredydd's MSN", &sc, SERVICE_CAN_GROUPCHAT, "#880000", NULL, NULL, NULL};
eb_plugin_info plugin_info = {
  "MSN Messenger",
  "Meredydd's libMSN plugin",
  "1.0",
  "Whenever",
  msn_plugin_init,
  msn_plugin_finish
};

void eb_msn_format_message (message * msg);
}

typedef struct {
	int fd;
	int tag;
}tag_info;

EList * tags=NULL;
EList * msn_states=NULL;

void eb_msn_login( eb_local_account * account );
void eb_msn_logout( eb_local_account * account );
void eb_msn_setup_local_account(eb_local_account * account);
void eb_msn_release_local_account(eb_local_account * account);

void eb_msn_add_user(eb_local_account * ela, eb_account * buddy);
void eb_msn_del_user(eb_account * buddy);

void eb_msn_set_away(eb_local_account * ela, char * short_msg, char * long_msg);
void eb_msn_unset_away(eb_local_account * ela);

void eb_msn_set_friendlyname(eb_pref * pref, void * tag);

EList * eb_msn_get_states(void) { return msn_states; }
void eb_msn_set_status(eb_local_account * account, char * status);

char * eb_msn_send_im(eb_account * to, char * body);
void eb_msn_send_data_message(eb_account *account_to, char * filename, char * contenttype, char * disposition, int reported_length);

void eb_msn_group_chat_join(eb_local_account * ela, char * name);
void eb_msn_group_chat_leave(eb_group_chat * chat);
char * eb_msn_group_chat_send(eb_group_chat * chat, char * msg);
void eb_msn_group_chat_invite(eb_group_chat * chat, char * user);

int msn_plugin_init()
{
  eb_debug(DBG_MOD, "MSN init\n");

  eb_put_default(registry, "config/services/msn/server", "messenger.hotmail.com");

  memset(&sc, 0, sizeof(sc));

  sc.login=eb_msn_login;
  sc.logout=eb_msn_logout;
  sc.set_current_state=eb_msn_set_status;

  sc.setup_local_account=eb_msn_setup_local_account;
  sc.release_local_account=eb_msn_release_local_account;

  sc.send_im=eb_msn_send_im;
  sc.send_data_message=eb_msn_send_data_message;
  sc.add_user=eb_msn_add_user;
  sc.del_user=eb_msn_del_user;

  sc.set_away=eb_msn_set_away;
  sc.unset_away=eb_msn_unset_away;

  sc.group_chat_send=eb_msn_group_chat_send;
  sc.join_group_chat=eb_msn_group_chat_join;
  sc.leave_group_chat=eb_msn_group_chat_leave;
  sc.group_chat_invite=eb_msn_group_chat_invite;

  msn_states=e_list_append(msn_states, strdup("Online"));
  msn_states=e_list_append(msn_states, strdup("Away"));
  msn_states=e_list_append(msn_states, strdup("Be Right Back"));
  msn_states=e_list_append(msn_states, strdup("Busy"));
  msn_states=e_list_append(msn_states, strdup("On the Phone"));
  msn_states=e_list_append(msn_states, strdup("Out to Lunch"));
  msn_states=e_list_append(msn_states, strdup("Hidden"));
  msn_states=e_list_append(msn_states, strdup("Offline"));

  msn_service_info.states=msn_states;

  eb_load_service(&msn_service_info);


  return 0;
}

int msn_plugin_finish()
{
  return 0;
}

/*************************************************************************************
 *                             End Module Code
 ************************************************************************************/

/* Use this struct to hold any service specific information you need
 * about people on your contact list
 */

typedef struct _eb_msn_local_account_data
{
  char * password; // account password
//  int status;			// the current status of the user
  char * upcoming_status;
  eb_pref_page * prefpage;
  msnconn * mc; // Notification Server connection
} eb_msn_local_account_data;

/*
typedef struct _eb_msn_buddy_account_data
{
  eb_inlined_data_state inline_state;
} eb_msn_buddy_account_data;
*/

void eb_msn_pass_cb(eb_pref * pref, void * tag)
{
  eb_local_account * acc=(eb_local_account *)tag;
  eb_msn_local_account_data * lad=GET_LAD(acc);
  if(acc->connected) { return; }

  free(lad->upcoming_status);
  lad->upcoming_status=strdup("Offline");
  msn_clean_up(lad->mc);
  lad->mc=new msnconn;

  free(lad->password);
  lad->password=strdup(eb_get_value(acc->config_key, "password"));

  msn_init(lad->mc, acc->handle, lad->password);
}

void eb_msn_setup_local_account(eb_local_account * account)
{
  eb_msn_local_account_data * lad=new eb_msn_local_account_data;
  account->protocol_data=lad;
  lad->password=strdup(eb_get_value(account->config_key, "password"));
  lad->mc=new msnconn;
  lad->upcoming_status=strdup("Online");
  msn_init(lad->mc, account->handle, lad->password);

  char * tmp=new char[strlen(account->handle)+10];
  char * tmp2=new char[strlen(account->handle)+10];
  strcpy(tmp, account->handle);
  strcpy(tmp2, account->handle);
  strcat(tmp, " (MSN)");
  strcat(tmp2, "_MSN");
  lad->prefpage=eb_make_pref_page(account_prefs, tmp2, tmp);
  delete tmp;
  delete tmp2;

  eb_add_component(lad->prefpage, EB_PREF_TOGGLE, "excl_soa", "Exclude from \"Sign On All\"", account->config_key, "excl_soa", NULL, NULL);

  tmp=new char[strlen(account->handle)+20];
  strcpy(tmp, "Username: ");
  strcat(tmp, account->handle);
  eb_add_component(lad->prefpage, EB_PREF_LABEL, "namelbl", tmp, registry, "params/scratch", NULL, NULL);
  delete tmp;

  eb_add_component(lad->prefpage, EB_PREF_PASSWORD, "password", "Password:", account->config_key, "password", eb_msn_pass_cb, account);
  eb_add_component(lad->prefpage, EB_PREF_STRING, "friendlyname", "Friendly Name (alias):", account->config_key, "friendlyname", eb_msn_set_friendlyname, account);
}

void eb_msn_release_local_account(eb_local_account * account)
{
  eb_msn_local_account_data * lad=GET_LAD(account);
  delete lad->mc;
  eb_destroy_pref_page(lad->prefpage);
  delete lad;
  account->protocol_data=NULL;
}

void eb_msn_login( eb_local_account * account )
{
  if(atoi(eb_get_value(account->config_key, "excl_soa")))
  {
    printf("MSN excluding itself from Sign On All\n");
    return;
  }

  eb_msn_set_status(account, "Online");
}

void eb_msn_logout( eb_local_account * account )
{
  eb_msn_local_account_data * lad=GET_LAD(account);

  if(!account->connected) { return; } // already done...

  free(lad->upcoming_status);
  lad->upcoming_status=strdup("Offline");

  msn_clean_up(lad->mc); // nuke the whole thing...
  EList * condemned=NULL;
  for(llist * n=connections; n; n=n->next)
  {
    msnconn * c=(msnconn *)n->data;
    if(c->type==CONN_SB && !strcmp(((authdata_SB *)c->auth)->username, account->handle))
    { condemned=e_list_append(condemned, c); }
  }
  
  for(EList * n=condemned; n!=NULL; n=n->next)
  {
    msn_clean_up((msnconn *)n->data);
  }
  
  e_list_free(condemned);
}

void eb_msn_set_status(eb_local_account * account, char * status)
{
  eb_msn_local_account_data * lad=GET_LAD(account);

  if(!strcmp(status, "Offline"))
  {
    free(lad->upcoming_status);
    lad->upcoming_status=strdup("Offline");
    // flags to closing_connection() that this is a deliberate logout
    eb_log_out_account(account);
  } else {
    if(!account->ready)
    {
      if(!account->connected)
      {
        account->connected=1;
        eb_local_account_update(account);
        msn_connect(lad->mc, eb_get_value(registry, "config/services/msn/server"), 1863);
        eb_msn_login(account);
      }

      free(lad->upcoming_status);
      lad->upcoming_status=strdup(status);
    } else {
      if(!strcmp(status, "Online"))
      {
        msn_set_state(lad->mc, "NLN");
      } else if(!strcmp(status, "Away")) {
        msn_set_state(lad->mc, "AWY");
      } else if(!strcmp(status, "Busy")) {
        msn_set_state(lad->mc, "BSY");
      } else if(!strcmp(status, "Be Right Back")) {
        msn_set_state(lad->mc, "BRB");
      } else if(!strcmp(status, "On the Phone")) {
        msn_set_state(lad->mc, "PHN");
      } else if(!strcmp(status, "Out to Lunch")) {
        msn_set_state(lad->mc, "LUN");
      } else if(!strcmp(status, "Idle")) {
        msn_set_state(lad->mc, "IDL");
      } else if(!strcmp(status, "Hidden")) {
        msn_set_state(lad->mc, "HDN");
      }
    }
  }
}

void eb_msn_set_friendlyname(eb_pref * pref, void * tag)
{
  eb_local_account * ela=(eb_local_account *)tag;
  eb_msn_local_account_data * lad=GET_LAD(ela);
  char * fn=eb_get_value(ela->config_key, "friendlyname");

  if(ela->ready && fn[0]!='\0')
  {
    msn_set_friendlyname(lad->mc, fn);
  }

  printf("Setting FriendlyName to %s\n", fn);
}

void eb_msn_incoming(void * tag, int source, int conditions)
{
  msn_handle_incoming(source, conditions&EB_INPUT_READ, conditions&EB_INPUT_WRITE);
}

eb_local_account * eb_msn_get_local_account(msnconn * conn)
{
  EList * n;
  char * conn_handle=NULL;

  if(conn->type==CONN_NS)
  {
    conn_handle=((authdata_NS *)conn->auth)->username;
  } else {
    conn_handle=((authdata_SB *)conn->auth)->username;
  }

  for(n=local_accounts; n!=NULL; n=n->next)
  {
    eb_local_account * thisacc=(eb_local_account *)n->data;

    if(thisacc->service!=&msn_service_info) { continue; }

    if(!strcmp(thisacc->handle, conn_handle)) { return thisacc; }
  }

  return NULL;
}

eb_group_chat * eb_msn_get_chat(msnconn * conn)
{
  EList * n;

  for(n=group_chats; n!=NULL; n=n->next)
  {
    eb_group_chat * chat=(eb_group_chat *)n->data;

    if(chat->protocol_data==conn) { return chat; }
  }

  return NULL;
}

eb_account * eb_msn_get_remote_account(eb_local_account * la, char * handle)
{
  EList * n;

  for(n=la->buddies; n!=NULL; n=n->next)
  {
    eb_account * account=(eb_account *)n->data;

    if(!strcmp(account->handle, handle)) { return account; }
  }

  return NULL;
}

char * eb_msn_send_im(eb_account * to, char * body)
{
  eb_msn_local_account_data * lad=GET_LAD(to->buddy_of);

  if(!to->buddy_of->ready)
  {
    eb_show_error("Cannot send instant messages from an offline account", "MSN Error");
    free(body);
    return NULL;
  }

  body=eb_filter_string(EB_PREFILTER_OUT, body, to);
  if(body==NULL) { return NULL; }

  char * real=strdup(body);
  real=eb_filter_string(EB_POSTFILTER_OUT, real, to);
  if(real==NULL) { free(body); return NULL; }

  if(!strcmp(to->buddy_of->status_string, "Hidden"))
  {
/*    for(llist n=connections; n; n!=NULL)
    {
      if
    }
*/    
    msn_send_IM(lad->mc, to->handle, real);
  } else {
    msn_send_IM(lad->mc, to->handle, real);
  }

  free(real);

  return body;
}

void eb_msn_send_data_message(eb_account * to, char * filename, char * contenttype, char * disposition, int reported_length)
{
  eb_msn_local_account_data * lad=GET_LAD(to->buddy_of);

  if(!to->buddy_of->ready)
  {
    eb_show_error("Cannot send data messages from an offline account", "MSN Error");
    return;
  }

  if(!strcmp(disposition, "inline") && reported_length<5500)
  {
    char * buf[5];
    int a, num_msg;
    
    for(a=0; a<5; a++) { buf[a]=(char *)malloc(2048); }
    
    eb_package_inlined_data(filename, contenttype, reported_length, 1500,  buf, &num_msg);
    
    for(a=0; a<num_msg; a++)
    {
      msn_send_IM(lad->mc, to->handle, buf[a]);
    }
  
    for(a=0; a<5; a++) { free(buf[a]); }
    eb_sent_inline_data_message(to, filename, contenttype);
    
    return;
  }
  
  eb_notify_3rdperson(to->contact, "<font color=red><i>IRC cannot yet send large or non-inlined data messages");
}


void eb_msn_add_user(eb_local_account * ela, eb_account * buddy)
{
  msnconn * conn=GET_LAD(ela)->mc;

  if(!ela->ready) { return; }

  msn_add_to_list(conn, "FL", buddy->handle);

  if(eb_get_value(eb_get_key(eb_get_key(ela->config_key, "lists/AL"), buddy->handle), "key_prop")[0]=='\0')
  { msn_add_to_list(conn, "AL", buddy->handle); }

  // TODO: clean me up and don't make assumptions!
  // at least now, with the local copies of all the lists, signing on and off
  // again is *guaranteed* to clear things up

  eb_add_account(buddy->contact, ela, buddy);
}

void eb_msn_del_user(eb_account * buddy)
{
  msnconn * conn=GET_LAD(buddy->buddy_of)->mc;

  if(!buddy->buddy_of->ready) { return; }

  msn_del_from_list(conn, "FL", buddy->handle);

  if(eb_get_value(eb_get_key(eb_get_key(buddy->buddy_of->config_key, "lists/AL"), buddy->handle), "key_prop")[0]!='\0')
  {
    msn_del_from_list(conn, "AL", buddy->handle);
  } else {
    msn_del_from_list(conn, "BL", buddy->handle);
  }

  eb_put_value(eb_get_key(eb_get_key(buddy->buddy_of->config_key, "rl_exclude"), buddy->handle), "key_prop", "1");
  
  eb_destroy_inlined_data_state((eb_inlined_data_state *)buddy->protocol_data);
  
  eb_del_account(buddy);
}

void eb_msn_set_away(eb_local_account * ela, char * short_msg, char * long_msg)
{
  eb_msn_local_account_data * lad=GET_LAD(ela);
  char * msg=strdup(long_msg);

  for(int a=0; msg[a]!='\0'; a++)
  {
    msg[a]=tolower(msg[a]);
  }

  if(strstr(msg, "phone")) { msn_set_state(lad->mc, "PHN"); free(msg); return; }

  if(strstr(msg, "brb") || strstr(msg, "be right back"))
  { msn_set_state(lad->mc, "BRB"); free(msg); return; }

  if(strstr(msg, "phone")) { msn_set_state(lad->mc, "PHN"); free(msg); return; }

  if(strstr(msg, "lunch") || strstr(msg, "breakfast")
   || strstr(msg, "supper") || strstr(msg, "eat"))
  { msn_set_state(lad->mc, "LUN"); free(msg); return; }

  if(strstr(msg, "busy") || strstr(msg, "work")
   || strstr(long_msg, "doing something else"))
  { msn_set_state(lad->mc, "BSY"); free(msg); return; }

  msn_set_state(lad->mc, "AWY");

  free(msg);
}

void eb_msn_unset_away(eb_local_account * ela)
{
  eb_msn_local_account_data * lad=GET_LAD(ela);

  msn_set_state(lad->mc, "NLN");
}

void eb_msn_group_chat_join(eb_local_account * ela, char * name)
{
  msn_new_SB(GET_LAD(ela)->mc, ela);
}

void eb_msn_group_chat_leave(eb_group_chat * chat)
{
  msn_clean_up((msnconn *)chat->protocol_data);
}

char * eb_msn_group_chat_send(eb_group_chat * chat, char * msg)
{
  char * processed;
  processed=eb_filter_string(EB_GROUP_PREFILTER_OUT, msg, chat);
  if(processed==NULL) { return NULL;}
  char * retval=strdup(processed);
  processed=eb_filter_string(EB_GROUP_POSTFILTER_OUT, processed, chat);
  if(processed==NULL) { free(retval); return NULL; }

  msn_send_IM((msnconn *)chat->protocol_data, NULL, msg);
  free(processed);

  return retval;
}

void eb_msn_group_chat_invite(eb_group_chat * chat, char * user)
{
  printf("Inviting %s\n", user);
  msn_invite_user((msnconn *)chat->protocol_data, user);
}

void ext_register_sock(int s, int reading, int writing)
{
  tag_info * ti=new tag_info;
  int conditions=0;

  if(reading) { conditions|=EB_INPUT_READ; }
  if(writing) { conditions|=EB_INPUT_WRITE; }

  ti->fd=s;
  ti->tag=eb_input_add(s, conditions, eb_msn_incoming, NULL);
  tags=e_list_append(tags, ti);
}

void ext_unregister_sock(int s)
{
  for(EList * n=tags; n!=NULL; n=n->next)
  {
    tag_info * ti=(tag_info *)n->data;

    if(ti->fd==s)
    {
      eb_input_remove(ti->tag);
      tags=e_list_remove_link(tags, n);
      e_list_free_1(n);
      delete ti;
      break;
    }
  }
}

void ext_got_friendlyname(msnconn * conn, char * friendlyname)
{
  eb_local_account * ela=eb_msn_get_local_account(conn);

  eb_put_value(ela->config_key, "friendlyname", friendlyname);
  printf("Your friendlyname is now: %s\n", friendlyname);
}

void eb_msn_list_fill(eb_registry_key * key, llist * buddies)
{
  llist * n;

  for(n=buddies; n!=NULL; n=n->next)
  {
    userdata * ud=(userdata *)n->data;
    eb_registry_key * u_key=eb_get_key(key, ud->username);

    eb_put_value(u_key, "key_prop", "1");
  }
}

static void autoadd_response(int result, void * data)
{
  eb_account * acc=(eb_account *)data;
  msnconn * conn=GET_LAD(acc->buddy_of)->mc;

  acc->locked--;

  if(!result)
  {
    eb_del_account(acc);
  } else {
    msn_add_to_list(conn, "FL", acc->handle);

    if(eb_get_value(eb_get_key(eb_get_key(acc->buddy_of->config_key, "lists/AL"), acc->handle), "key_prop")[0]=='\0')
    { msn_add_to_list(conn, "AL", acc->handle); }
  }
}

void ext_got_info(msnconn * conn, syncinfo * info)
{
  eb_local_account * ela=eb_msn_get_local_account(conn);
  eb_registry_key * lkey;
  char * lists[]={"FL", "AL", "BL", "RL"};
  printf("Got the sync info!\n");

  ela->ready=1;
  eb_local_account_update(ela);
  eb_msn_set_status(ela, GET_LAD(ela)->upcoming_status);

  if(info==NULL) { printf("Nothing changed\n"); return; }

  llist * lptrs[]={info->fl, info->al, info->bl, info->rl};

  lkey=eb_get_key(ela->config_key, "lists");

  for(int a=0; a<4; a++)
  {
    eb_del_key(lkey, eb_get_key(lkey, lists[a]));
    eb_msn_list_fill(eb_get_key(lkey, lists[a]), lptrs[a]);
  }

  for(llist * n=info->fl; n!=NULL; n=n->next)
  {
    userdata * ud=(userdata *)n->data;
    eb_account * acc=eb_get_account(ela->handle, ela->service_name, ud->username);
    if(acc==NULL)
    {
      printf("Whoa! Unknown account, adding it quick!\n");

      eb_group * group=eb_get_group("Buddies");
      if(group==NULL)
      { group=eb_add_group("Buddies"); }

      eb_contact * cont=eb_get_contact("Buddies", ud->friendlyname);
      if(cont==NULL)
      { cont=eb_add_contact(group, ud->friendlyname); }

      eb_account * acc=(eb_account *)malloc(sizeof(eb_account));
      acc->handle=strdup(ud->username);
      acc->status_string=strdup("(Offline)");
      acc->status=EB_ACCOUNT_OFFLINE;
      eb_add_account(cont, ela, acc);
    }
  }

  eb_registry_key * fkey=eb_get_key(lkey, "FL");
  eb_registry_key * akey=eb_get_key(lkey, "AL");
  eb_registry_key * bkey=eb_get_key(lkey, "BL");

  for(EList * n=ela->buddies; n!=NULL; n=n->next)
  {
    eb_account * acc=(eb_account *)n->data;

    if(eb_get_value(eb_get_key(fkey, acc->handle), "key_prop")[0]=='\0')
    {
      char * buf=new char[strlen(acc->handle)+strlen(acc->contact->name)+strlen(acc->contact->group->name)+256]; 
      sprintf(buf, "The account:\n\"%s\"\nin the contact:\n\"%s\" (%s)\nis on your local contact list, but not on the MSN server - perhaps you\ndeleted it somewhere else.\nDo you want this buddy on your contact list?", acc->handle, acc->contact->name, acc->contact->group->name);
      eb_show_yesno_dialog(buf, "MSN Buddy list mismatch", 0, autoadd_response, acc);
      free(buf);
      acc->locked++;
    }

    if(acc->contact->ignore==NULL) // if they're ignored, don't fiddle with allow & block
    {
      if(eb_get_value(eb_get_key(bkey, acc->handle), "key_prop")[0]!='\0')
      { msn_del_from_list(conn, "BL", acc->handle); }
    }
  }
}

void ext_latest_serial(msnconn * conn, int serial)
{
  eb_local_account * ela=eb_msn_get_local_account(conn);
  if(ela!=NULL)
  {
    char buf[16];
    sprintf(buf, "%d", serial);
    eb_put_value(ela->config_key, "list_serial", buf);
  }
  ela->ready=1;
  eb_local_account_update(ela);
  eb_msn_set_status(ela, GET_LAD(ela)->upcoming_status);
  
  printf("The latest serial number is: %d\n", serial);
}

void ext_got_GTC(msnconn * conn, char c)
{
  printf("Your GTC value is now %c\n", c);
}

void ext_got_BLP(msnconn * conn, char c)
{
  printf("Your BLP value is now %cL\n", c);
}

class eb_msn_auth_user {
  public:
  char * username;
  char * friendlyname;
  eb_local_account * ela;
  
  eb_msn_auth_user(char * u, char * f, eb_local_account * l)
  { username=msn_permstring(u); friendlyname=msn_permstring(f); ela=l; ela->locked++; }
  
  ~eb_msn_auth_user()
  { delete username; delete friendlyname; ela->locked--; } 
};

void eb_msn_authorise_user(int response, void * tag)
{
  eb_msn_auth_user * emau = (eb_msn_auth_user *)tag;
  msnconn * conn=GET_LAD(emau->ela)->mc;
  
  if(response)
  {
    if(eb_get_value(eb_get_key(eb_get_key(emau->ela->config_key, "lists/FL"), emau->username), "key_prop")[0]=='\0')
    { msn_add_to_list(conn, "FL", emau->username); }
    if(eb_get_value(eb_get_key(eb_get_key(emau->ela->config_key, "lists/AL"), emau->username), "key_prop")[0]=='\0')
    { msn_add_to_list(conn, "AL", emau->username); }
    eb_add_account_plus("MSN users", emau->friendlyname, emau->ela, emau->username);
  } else {
    eb_put_value(eb_get_key(eb_get_key(emau->ela->config_key, "rl_exclude"), emau->username), "key_prop", "1");
  }
  
  delete emau;
}

void ext_new_RL_entry(msnconn * conn, char * username, char * friendlyname)
{
  eb_local_account * ela=eb_msn_get_local_account(conn);
  char * tmp;

  if(ela==NULL) { printf("Martian msnconn got a new RL entry\n"); return; }

  if(eb_get_value(eb_get_key(eb_get_key(ela->config_key, "rl_exclude"), username), "key_prop")[0]!='\0')
  { return; }
  
  if(eb_get_value(eb_get_key(eb_get_key(ela->config_key, "lists/FL"), username), "key_prop")[0]=='\0')
  {
    tmp=(char *)malloc(strlen(username)+strlen(friendlyname)+128);
    sprintf(tmp, "%s (%s) has added you to their contact list\nShould they be added to yours?",
      friendlyname, username);
    eb_show_yesno_dialog(tmp, "New user on buddy list", 1, eb_msn_authorise_user, new eb_msn_auth_user(username, friendlyname, ela));
    free(tmp);
  }
}

void ext_new_list_entry(msnconn * conn, char * list, char * username)
{
  eb_local_account * ela=eb_msn_get_local_account(conn);
  if(ela==NULL)
  { printf("Martian msnconn in new list entry\n"); return; }

  eb_registry_key * lkey=eb_get_key(ela->config_key, "lists");
  lkey=eb_get_key(lkey, list);
  lkey=eb_get_key(lkey, username);
  eb_put_value(lkey, "key_prop", "1");

  if(list[0]=='F')
  {
    eb_account * acc=eb_get_account(ela->handle, "MSN", username);

    if(acc==NULL)
    {
      eb_group * group=eb_get_group("Unknown");
      if(group==NULL)
      { group=eb_add_group("Unknown"); }

      eb_contact * cont=eb_get_contact("Unknown", username);
      if(cont==NULL)
      { cont=eb_add_contact(group, username); }

      eb_account * acc=(eb_account *)malloc(sizeof(eb_account));
      acc->handle=strdup(username);
      acc->status_string=strdup("(Offline)");
      eb_add_account(cont, ela, acc);
    }
  }

  printf("%s is now on your %s\n", username, list);
}

void ext_del_list_entry(msnconn * conn, char * list, char * username)
{
  eb_local_account * ela=eb_msn_get_local_account(conn);
  if(ela==NULL)
  { printf("Martian msnconn in list delete callback\n"); return; }

  eb_registry_key * lkey=eb_get_key(ela->config_key, "lists");
  lkey=eb_get_key(lkey, list);
  eb_del_key(lkey, eb_get_key(lkey, username));

  printf("%s has been removed from your %s\n", username, list);
}

void ext_show_error(msnconn * conn, char * msg, int code)
{
  eb_show_error(msg, "MSN Error");
}

void ext_buddy_set(msnconn * conn, char * buddy, char * friendlyname, char * status)
{
  eb_local_account * la=eb_msn_get_local_account(conn);
  eb_account * account;
  int do_login=0;

  if(la==NULL)
  {
    eb_debug(DBG_MOD, "Martian msnconn!");
    return;
  }
  account=eb_msn_get_remote_account(la, buddy);
  if(account==NULL)
  {
    //eb_show_error("Just got status of an unknown account", "MSN debug warning");
    printf("MSN: ext_buddy_set(): Got bogus status message %s:%s for LA %s\n",
      buddy, status, la->handle);
    eb_debug(DBG_MOD, "Hitherto-unknown account - we ought to do some buddy-list adding right now...\n");
    
    account=eb_add_account_plus("Buddies", friendlyname, la, buddy);
  }

  if(account->status==EB_ACCOUNT_OFFLINE) { do_login=1; }

  if(!strcmp(status, "NLN"))
  {
    account->status=EB_ACCOUNT_ONLINE;
  } else {
    account->status=EB_ACCOUNT_AWAY;
  }
  free(account->status_string);

  if(!strcmp(status, "NLN"))
  {
    account->status_string=strdup("");
  } else if(!strcmp(status, "AWY")) {
    account->status_string=strdup("(Away)");
  } else if(!strcmp(status, "BSY")) {
    account->status_string=strdup("(Busy)");
  } else if(!strcmp(status, "BRB")) {
    account->status_string=strdup("(Be Right Back)");
  } else if(!strcmp(status, "PHN")) {
    account->status_string=strdup("(On the Phone)");
  } else if(!strcmp(status, "LUN")) {
    account->status_string=strdup("(Out to Lunch)");
  } else if(!strcmp(status, "IDL")) {
    account->status_string=strdup("(Idle)");
  } else {
    account->status_string=strdup("(BOGUS STATE)");
  }

  if(do_login) { eb_buddy_login(account); }
  eb_buddy_update_status(account);
}

void ext_buddy_offline(msnconn * conn, char * buddy)
{
  eb_local_account * la=eb_msn_get_local_account(conn);
  eb_account * account;

  if(la==NULL)
  {
    eb_debug(DBG_MOD, "Martian msnconn!");
    return;
  }
  account=eb_msn_get_remote_account(la, buddy);
  if(account==NULL)
  {
    eb_debug(DBG_MOD, "Martian user signing off\n")
    return;
  }
  
  for(llist * l=connections; l; l=l->next)
  {
    msnconn * c=(msnconn *)l->data;
    if(c->type==CONN_SB && !strcmp(((authdata_SB *)c->auth)->username,la->handle)
     && c->users!=NULL && c->users->next==NULL
     && !strcmp(((char_data *)c->users->data)->c, buddy))
    {
      account->status=EB_ACCOUNT_AWAY;
      free(account->status_string);
      account->status_string=strdup("Hidden");
      
      eb_buddy_update_status(account);
      return;
    }
  }

  account->status=EB_ACCOUNT_OFFLINE;
  free(account->status_string);
  account->status_string=strdup("Offline");

  eb_buddy_logout(account);
}

void ext_got_SB(msnconn * conn, void * tag)
{
  eb_local_account * ela=(eb_local_account *)tag;
  eb_group_chat * chat=eb_create_group_chat(ela);
  chat->title=strdup("MSN chat");
  chat->protocol_data=conn;
  eb_group_chat_joined(chat, ela->handle);
  eb_announce_group_chat(chat);
  printf("Got switchboard connection\n");
}

void ext_user_joined(msnconn * conn, char * username, char * friendlyname, int is_initial)
{
  eb_local_account * ela=eb_msn_get_local_account(conn);
  eb_group_chat * chat=eb_msn_get_chat(conn);
  
  if(ela==NULL)
  { printf("Dud SB connection acquired user!\n"); msn_clean_up(conn); return; }

  eb_account * acc=eb_get_account(ela->handle, "MSN", username);
  if(acc->status==EB_ACCOUNT_OFFLINE)
  {
    free(acc->status_string);
    acc->status_string=strdup("Hidden");
    acc->status=EB_ACCOUNT_AWAY;
    eb_buddy_update(acc);
  }

  if(chat==NULL)
  {
    if(conn->users->next==NULL) { return; } // just an ordinary one-on-one
    chat=eb_create_group_chat(ela);

    chat->title=strdup("MSN Chat");
    chat->protocol_data=conn;

    eb_group_chat_joined(chat, ela->handle);

    llist * n;
    for(n=conn->users; n!=NULL; n=n->next)
    {
      if(n->next==NULL) { eb_announce_group_chat(chat); }
      eb_group_chat_joined(chat, ((char_data *)n->data)->c);
    }

    eb_announce_group_chat(chat); // just in case - should be unnecessary
  } else {
    eb_group_chat_joined(chat, username);
  }

  if(!is_initial)
  {
    char * buf=new char[strlen(username)+strlen(friendlyname)+64];
    sprintf(buf, "<font color=#666666><i><b>%s</b> (%s) has joined", friendlyname, username);
    eb_group_chat_3rdperson(chat, buf);
    delete buf;
  }
}

void ext_user_left(msnconn * conn, char * username)
{
  eb_group_chat * chat=eb_msn_get_chat(conn);

  if(chat==NULL)
  {
    eb_account * acc=eb_get_account(((authdata_SB *)conn->auth)->username, "MSN", username);
    if(acc!=NULL && !strcmp(acc->status_string, "Hidden"))
    { ext_buddy_offline(GET_LAD(acc->buddy_of)->mc, username); }

    return;
  }

  char * buf=new char[strlen(username)+64];
  sprintf(buf, "<font color=#666666><i><b>%s</b> has left", username);
  eb_group_chat_3rdperson(chat, buf);
  delete buf;

  eb_group_chat_left(chat, username);
}

void ext_got_IM(msnconn * conn, char * username, char * friendlyname, message * msg)
{
  eb_local_account * la=eb_msn_get_local_account(conn);
  eb_group_chat * chat=eb_msn_get_chat(conn);
  eb_account * acc;
  if(la==NULL && chat==NULL) { eb_debug(DBG_MOD, "Martian msnconn got a message"); return; }
  acc=eb_msn_get_remote_account(la, username);

  if(chat!=NULL)
  {
    char * processed=strdup(msg->body);
    processed=eb_filter_string(EB_GROUP_FILTER_IN, processed, chat);
    if(processed==NULL) { return; }
    eb_group_chat_message(chat, username, processed);
    free(processed);
    return;
  }

  if(acc==NULL)
  {
    eb_debug(DBG_MOD, "Unknown user sent me a message - add them!");
    eb_show_error("A user we do not know about has sent you a message. They will be added to your Unknown group.\nThis should not have to happen - please report this bug at www.everybuddy.com", "MSN Warning");

    acc=eb_add_account_plus("Unknown", friendlyname, la, username);
    acc->status_string=strdup("[Unconfirmed]");
    acc->status=EB_ACCOUNT_AWAY;
    eb_buddy_login(acc);
    eb_buddy_update_status(acc);

    msn_add_to_list(GET_LAD(la)->mc, "FL", username);
  }

  if(!strncmp(msg->body, "EB+]#[", 6)) // inlined transfer
  {
    if(eb_handle_inlined_data(acc, msg->body, strlen(msg->body),
      (eb_inlined_data_state **)&(acc->protocol_data))==0)
    { return; }
  }
  
  char * processed=strdup(msg->body);
  processed=eb_filter_string(EB_FILTER_IN, processed, acc);

  if(processed==NULL) { return; }
  eb_incoming_message(acc, processed);

  free(processed);
}

void ext_IM_failed(msnconn * conn)
{
  eb_group_chat * chat=eb_msn_get_chat(conn);

  if(chat!=NULL)
  {
    eb_group_chat_3rdperson(chat, "<font color=red><i><b>Warning:</b> Your last message could not be delivered to everyone else in this discussion");
    return;
  }

  if(conn->users!=NULL) {
    eb_local_account * ela=eb_msn_get_local_account(conn);
    if(ela!=NULL)
    {
      eb_account * acc=eb_get_account(((char_data *)conn->users->data)->c, "MSN", ela->handle);
      if(acc!=NULL)
      {
        eb_notify_3rdperson(acc->contact, "<font color=red><i><b>Warning:</b> Your last message could not be delivered");
        return;
      }
    }
  }

  eb_show_error("Your last message could not be sent - try re-sending it.", "MSN Error");
}

void ext_typing_user(msnconn * conn, char * username, char * friendlyname)
{
  printf("\t%s (%s) is typing...\n", friendlyname, username);
}

void ext_initial_email(msnconn * conn, int unread_inbox, int unread_folders)
{
  if(unread_inbox>0) { printf("You have %d new messages in your Inbox\n", unread_inbox); }
  if(unread_folders>0) { printf("You have %d new messages in other folders.\n", unread_folders); }
}

void ext_new_mail_arrived(msnconn * conn, char * from, char * subject)
{
  printf("New e-mail has arrived from %s.\nSubject: %s\n", from, subject);
}

void ext_filetrans_invite(msnconn * conn, char * username, char * friendlyname, invitation_ftp * inv)
{
  printf("Got file transfer invitation from %s (%s)\n", friendlyname, username);
  msn_filetrans_reject(inv);
}

void ext_filetrans_progress(invitation_ftp * inv, char * status, unsigned long sent, unsigned long total)
{
  printf("File transfer: %s\t(%lu/%lu bytes sent)\n", status, sent, total);
}

void ext_filetrans_failed(invitation_ftp * inv, int error, char * message)
{
  char * buf=(char *)malloc(32+strlen(message));
  sprintf(buf, "MSN file transfer failed: %s\n", message);
  eb_show_error(buf, "MSN file transfer error");
  free(buf);
}

void ext_filetrans_success(invitation_ftp * inv)
{
  printf("File transfer successfully completed\n");
}

void ext_new_connection(msnconn * conn)
{
  if(conn->type==CONN_NS)
  {
    eb_local_account * ela=eb_msn_get_local_account(conn);
    int serial;
    if(ela==NULL)
    {
      eb_debug(DBG_MOD, "Martian NS connection on socket %d!\n", conn->sock);
      return;
    }
    serial=atoi(eb_get_value(ela->config_key, "list_serial"));
    msn_sync_lists(conn, serial);

    eb_msn_local_account_data * lad=GET_LAD(ela);
    eb_local_account_update(ela);
  }
}

void ext_closing_connection(msnconn * conn)
{
  eb_group_chat * chat=eb_msn_get_chat(conn);

  if(chat!=NULL)
  {
    eb_destroy_group_chat(chat);
    return;
  }

  if(conn->type==CONN_SB)
  {
    printf("Dud SB conn lost\n");
    return; // Big deal...
  }

  eb_local_account * ela=eb_msn_get_local_account(conn);
  if(ela==NULL)
  { eb_debug(DBG_MOD, "Closed martian msnconn\n"); return; }

  eb_msn_local_account_data * lad=GET_LAD(ela);
  eb_debug(DBG_MOD, "Connection closed when upcoming_status==\"%s\"\n", lad->upcoming_status);
  if(strcmp(lad->upcoming_status, "Offline"))
  {
    eb_show_error("Lost connection to server", "MSN error");
  }

  ela->ready=0;
  ela->connected=0;
  free(ela->status_string);
  ela->status_string=strdup("Offline");
  eb_log_out_account(ela);
  lad->mc=new msnconn;
  free(lad->upcoming_status);
  lad->upcoming_status=strdup("Online"); // default for next sign_on_all
  eb_local_account_update(ela);

  lad->mc=new msnconn;
  msn_init(lad->mc, ela->handle, lad->password);
}

void ext_changed_state(msnconn * conn, char * state)
{
  eb_local_account * la=eb_msn_get_local_account(conn);

  if(la==NULL) { eb_debug(DBG_MOD, "Martian msnconn changed state\n"); return; }

  if(!strcmp(state, "FLN"))
  {
    la->ready=0;
  } else {
    la->ready=1;
  }

  free(la->status_string);

  if(!strcmp(state, "NLN"))
  {
    la->status_string=strdup("Online");
  } else if(!strcmp(state, "AWY")) {
    la->status_string=strdup("Away");
  } else if(!strcmp(state, "BSY")) {
    la->status_string=strdup("Busy");
  } else if(!strcmp(state, "BRB")) {
    la->status_string=strdup("Be Right Back");
  } else if(!strcmp(state, "PHN")) {
    la->status_string=strdup("On the Phone");
  } else if(!strcmp(state, "LUN")) {
    la->status_string=strdup("Out to Lunch");
  } else if(!strcmp(state, "IDL")) {
    la->status_string=strdup("Idle");
  } else if(!strcmp(state, "HDN")) {
    la->status_string=strdup("Hidden");
  } else if(!strcmp(state, "FLN")) {
    la->status_string=strdup("Offline");
  } else {
    la->status_string=strdup("Status Error");
  }

  eb_local_account_update(la);
}

void ext_protocol_transcript(int writing, const char* buf)
{
  printf("%s %s\n", (writing)?(">MSN<"):("<MSN>"), buf);
}

int ext_connect_socket(char * hostname, int port)
{
  return eb_connect_sync_socket(hostname, port);
}

int ext_server_socket(int port)
{
  int s;
  struct sockaddr_in addr;

  if((s=socket(AF_INET, SOCK_STREAM, 0))<0)
  {
    return -1;
  }

  memset(&addr, 0, sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_port=htons(port);

  if(bind(s, (sockaddr *)(&addr), sizeof(addr))<0 || listen(s, 1)<0)
  {
    close(s);
    return -1;
  }

  return s;
}

char * ext_get_IP(void)
{
  struct hostent * hn;
  char buf2[1024];

  gethostname(buf2,1024);
  hn = gethostbyname(buf2);

  return inet_ntoa( *((struct in_addr*)hn->h_addr));
}
