// rainbow.c - rainbow text filter

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "plugin_api.h"
#include "contactlist.h"
#include "actions.h"
#include "prefs.h"
#include "dialog.h"
#include "message_parse.h"
#include "gui_comms.h"

#define INTERP(a,b) ((a*pos+b*(len-pos))/len)

static char * do_rainbow(char * text, void * target);

void eb_rainbow_init(void)
{
  eb_pref_page * page;

  eb_add_filter(EB_PREFILTER_OUT, do_rainbow, -11);
  
  page=eb_make_pref_page(features, "rainbow", "Rainbow Text");
  eb_add_component(page, EB_PREF_TOGGLE, "do", "Turn text rainbow colours", registry, "config/rainbow/do", NULL, NULL);
  eb_add_component(page, EB_PREF_STRING, "scol", "Start colour (HTML form)", registry, "config/rainbow/start", NULL, NULL);
  eb_add_component(page, EB_PREF_STRING, "ecol", "End colour (HTML form)", registry, "config/rainbow/end", NULL, NULL);
}

static char * do_rainbow(char * text, void * target)
{
  int len=strlen(text);
  int pos=0, wpos=0;
  int rb, gb, bb, re, ge, be;
  char * scol;
  char * ecol;
  char * dest;
  char buf[3];
  int skip=1;
  
  if(eb_get_value(registry, "config/rainbow/do")[0]!='1') { return text; }
  
  scol=eb_get_value(registry, "config/rainbow/start");
  ecol=eb_get_value(registry, "config/rainbow/end");

  if(scol[0]=='#') { scol++; }
  if(ecol[0]=='#') { ecol++; }
  if(strlen(scol)<6 || strlen(ecol)<6) { return text; }
  
  buf[2]='\0';
  buf[0]=scol[0]; buf[1]=scol[1];
  rb=strtol(buf, NULL, 16);
  buf[0]=scol[2]; buf[1]=scol[3];
  gb=strtol(buf, NULL, 16);
  buf[0]=scol[4]; buf[1]=scol[5];
  bb=strtol(buf, NULL, 16);

  buf[0]=ecol[0]; buf[1]=ecol[1];
  re=strtol(buf, NULL, 16);
  buf[0]=ecol[2]; buf[1]=ecol[3];
  ge=strtol(buf, NULL, 16);
  buf[0]=ecol[4]; buf[1]=ecol[5];
  be=strtol(buf, NULL, 16);

  if(len>1000) { return text; }
  
  for(skip=1; len*22/skip>2000; skip++);
  
  dest=(char *)malloc(len*21+1);
  for(pos=0; pos<len; pos++)
  {
    if(pos%skip==0)
    {
      wpos+=sprintf(dest+wpos, "<font color=#%02x%02x%02x>",
        INTERP(rb, re), INTERP(gb, ge), INTERP(bb, be));
    
      if((unsigned char)text[pos]>=128 && text[pos+1]!='\0') // multi-byte character
      { pos++; dest[wpos++]=text[pos]; }
    }
    
    *(dest+(wpos++))=text[pos];
  }
  dest[wpos]='\0';
  free(text);
  
  return dest;
}
