// autotrans.c - automatic translation using Babelfish

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "plugin_api.h"
#include "contactlist.h"
#include "actions.h"
#include "prefs.h"
#include "dialog.h"
#include "message_parse.h"
#include "gui_comms.h"


#include "stream.h"

typedef struct _trans_ip {
  eb_account * buddy;
  char * original;
  int stage;
  int tag;
  int direction;

  char * buf;
  int nalloc;
  int pos;
} trans_ip;

static eb_action * contact_action;
static eb_action * account_action;

static int ignore=0;


static void do_manual_trans(eb_pref * pref, void * tag);

static void account_callback(void * data);
static void contact_callback(void * data);
static void langselect_cb(char * response, void * data);

static void got_data(void * data, int s, int conditions);
static void get_response(int s, int code, EList * headers, void * data);
static char * do_translation(char * s, char * lang_from, char * lang_to, eb_account * buddy, int direction);
static char * translate_out(char * msg, void * data);
static char * translate_in(char * msg, void * data);
static void process_success(trans_ip * tip, char * s);
static char * trans_URLEncode(char * s);

static char * langlist[] = {
  " Do Not Translate ",
  "en (English)",
  "fr (French)",
  "de (German)",
  "it (Italian)",
  "pt (Portuguese)",
  "es (Spanish)",
  "ru (Russian)",
  "ko (Korean)",
  "ja (Japanese)",
  "zh (Chinese)",
  NULL
};

void eb_autotrans_init(void)
{
  eb_pref_page * page=eb_make_pref_page(features, "autotrans", "Translation");
  eb_add_component(page, EB_PREF_LABEL, "lbl", "Configure the automatic translation service (powered by Babelfish)", registry, "tmp/dump", NULL, NULL);
  eb_add_component(page, EB_PREF_TOGGLE, "do", "Perform automatic translation", registry, "config/autotrans/do", NULL, NULL);
  eb_add_option_strings(page, "my_lang", "My language:", registry, "config/autotrans/my_lang", NULL, NULL, langlist, 11);

  contact_action=eb_create_action("Select language", contact_callback);
  account_action=eb_create_action("Select language", account_callback);

  eb_add_component(page, EB_PREF_LABEL, "lbl2", "Manual translation", registry, "tmp/dump", NULL, NULL);
  eb_add_option_strings(page, "dest_lang", "Translate from:", registry, "tmp/tr_dest", NULL, NULL, langlist, 11);
  eb_add_component(page, EB_PREF_STRING, "tr_text", "Text:", registry, "tmp/tr_text", NULL, NULL);
  eb_add_component(page, EB_PREF_BUTTON, "translate", "Translate!", registry, "tmp/dump", do_manual_trans, NULL);
    
  
  eb_contact_actions=e_list_append(eb_contact_actions, contact_action);
  eb_buddy_actions=e_list_append(eb_buddy_actions, account_action);

  eb_add_filter(EB_FILTER_IN, translate_in, -10);
  eb_add_filter(EB_PREFILTER_OUT, translate_out, -10);

  eb_put_default(registry, "config/autotrans/do", "0");
}

static void do_manual_trans(eb_pref * pref, void * tag)
{
  char * lang_to=eb_get_value(registry, "config/autotrans/my_lang");
  char * lang_from=eb_get_value(registry, "tmp/tr_dest");

  fprintf(stderr, "Translating \"%s\"\n", eb_get_value(registry, "tmp/tr_text"));
  
  do_translation(strdup(eb_get_value(registry, "tmp/tr_text")), lang_from, lang_to, NULL, 0);
}

static void account_callback(void * data)
{
  eb_account * acc=(eb_account *)data;
  contact_callback(acc->contact);
}

static void contact_callback(void * data)
{
  eb_contact * contact=(eb_contact *)data;
  char * buf=(char *)malloc(512+strlen(contact->name));

  sprintf(buf, "Select which language to translate to/from when talking to %s:", contact->name);
  eb_show_list_dialog(buf, contact->name, langlist, langselect_cb, contact);
  free(buf);

  contact->locked++;
}

static void langselect_cb(char * response, void * data)
{
  eb_contact * contact=(eb_contact *)data;
  char lang[3];

  lang[0]=response[0];
  lang[1]=response[1];
  lang[2]='\0';

  eb_put_value(contact->config_key, "lang", lang);

  if(eb_get_value(registry, "config/autotrans/do")[0]!='1')
  {
    eb_show_error("Warning: This option will only take effect if you turn on automatic translation", "Warning");
  }

  contact->locked--;
}

static char * translate_in(char * msg, void * data)
{
  eb_account * acc=(eb_account *)data;
  char * lang_from=eb_get_value(acc->contact->config_key, "lang");
  char * lang_to=eb_get_value(registry, "config/autotrans/my_lang");

  return do_translation(msg, lang_from, lang_to, acc, EB_MSG_RECV);
}

static char * translate_out(char * msg, void * data)
{
  eb_account * acc=(eb_account *)data;
  char * lang_from=eb_get_value(registry, "config/autotrans/my_lang");
  char * lang_to=eb_get_value(acc->contact->config_key, "lang");

  return do_translation(msg, lang_from, lang_to, acc, EB_MSG_SEND);
}

static char * do_translation(char * omsg, char * lang_from, char * lang_to, eb_account * buddy, int direction)
{
  trans_ip * tip;
  char * encoded;
  char * url;
  EList * headers=NULL;

  if(lang_from[0]=='\0' || lang_from[0]==' ' || lang_to[0]=='\0' || lang_to[0]==' '
    || !strcmp(lang_from, lang_to) || ignore
    || eb_get_value(registry, "config/autotrans/do")[0]!='1')
  { ignore=0; return omsg; }
  // That ignore=0 makes sure that anything sent in response to a message arriving (ie away messages)
  // don't have autotrans disabled.

  if(buddy!=NULL)
  { buddy->locked++; }
  
  tip=(trans_ip *)malloc(sizeof(trans_ip));

  tip->buddy=buddy;
  tip->stage=0;
  tip->original=omsg;
  tip->direction=direction;
  encoded=trans_URLEncode(omsg);

  url=(char *)malloc(128+strlen(encoded));
  sprintf(url, "/babelfish/tr?doit=done&tt=urtlext&intl=1&urltext=%s&lp=%c%c_%c%c", encoded, lang_from[0], lang_from[1], lang_to[0], lang_to[1]);

  headers=e_list_append(headers, strdup("Connection: close"));
  eb_http_request("babelfish.altavista.com", 80, url, EB_HTTP_GET, NULL, get_response, tip);
  free(headers->data);
  e_list_free(headers);

  return NULL;
}

static void get_response(int s, int code, EList * headers, void * data)
{
  trans_ip * tip=(trans_ip *)data;
  tip->tag=eb_input_add(s, EB_INPUT_READ, got_data, tip);
  tip->buf=(char *)malloc(4000);
  tip->nalloc=4000;
  tip->pos=0;
}

static void got_data(void * data, int s, int conditions)
{
  trans_ip * tip=(trans_ip *)data;
  char buf[1000];
  int len=read(s, buf, sizeof(buf));

  if(len!=0)
  {
    if(tip->pos+len>=tip->nalloc)
    {
      char * abuf=(char *)malloc(tip->nalloc+4000);
      memcpy(abuf, tip->buf, tip->pos);
      free(tip->buf);
      tip->buf=abuf;
      tip->nalloc+=4000;
    }

    memcpy(tip->buf+tip->pos, buf, len);
    tip->pos+=len;
    tip->buf[tip->pos]='\0';
  } else {
    char * p=strstr(tip->buf, "name=\"q\"");

    if(p!=NULL)
    {
      p+=16; // Fast-forward to the beginning of the translated text
      if(p-tip->buf > tip->pos)
      {
        eb_show_error("Unclosed name tag! This should NOT happen - please report this problem, and the circumstances which caused it", "Translation failed");
      } else {
        char * s=strstr(p, "\">\n");
        if(s==NULL)
        {
          eb_show_error("Unclosed quote! This should NOT happen - please report this problem, and the circumstances which caused it", "Translation failed");
        } else {
          *s='\0';
          process_success(tip, p);
        }
      }
    } else {
      eb_show_error("Translation not found in response page - perhaps Babelfish have changed their page format?", "Translation failed");
    }
    // This will execute, however successful we were...

    eb_input_remove(tip->tag);
    if(tip->buddy!=NULL)
    { tip->buddy->locked--; }
    free(tip->buf);
    free(tip->original);
    free(tip);
  }
}

static void process_success(trans_ip * tip, char * s)
{
  char * new_msg;
  
  if(tip->buddy==NULL)
  {
    eb_show_error(s, "Translated text");
    return;
  }
  
  ignore=1;

  new_msg=(char *)malloc(strlen(s)+strlen(tip->original)+64);
  sprintf(new_msg, "%s\n--\n%s", tip->original, s);
  
  if(tip->direction==EB_MSG_SEND)
  {
    if(tip->buddy->buddy_of->service->sc->send_im!=NULL)
    {
      new_msg=tip->buddy->buddy_of->service->sc->send_im(tip->buddy, new_msg);
      
      if(new_msg!=NULL)
      {
        eb_sent_message(tip->buddy, new_msg);
        free(new_msg);
      }
    }
  } else {
    eb_incoming_message(tip->buddy, new_msg);
    free(new_msg);
  }
  
  tip->buddy->locked--;
  ignore=0;
}

static char * trans_URLEncode(char * s)
{
  char * rptr;
  char * wptr;
  char * retval;

  wptr=retval=(char *)malloc(sizeof(char)*strlen(s)*3+1);
  rptr=s;

  while(1)
  {
    if(*rptr=='\0')
    { *wptr='\0'; break; }
    if(!(isalpha(*rptr) || isdigit(*rptr)))
    {
      sprintf(wptr, "%%%2x", (int)(*rptr));

      rptr++;
      wptr+=3;
      continue;
    }

    *wptr=*rptr;
    wptr++;
    rptr++;
  }

  return retval;
}
