/***************************************************************************
                          irc.c  -  EB-lite's IRC module
                             -------------------
    begin                : Thu Sep 26 2002
    copyright            : (C) 2002 by the Everybuddy team
    email                : www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// OK, IRC is a simple protocol. Our challenge is to implement it as simply as possible.

// (One month later, as the number of lines approaches 1000):
// Ha. Ha. Ha.

#ifndef __MINGW32__
#define __IN_PLUGIN__
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#define GET_LAD(x) ((eb_irc_lad *)(x)->protocol_data)
#define GET_GCD(x) ((eb_irc_gcd *)(x)->protocol_data)

#include "services.h"
#include "plugin.h"
#include "plugin_api.h"
#include "gui_comms.h"
#include "elist.h"
#include "dialog.h"
#include "prefs.h"
#include "util.h"
#include "message_parse.h"

#define IRC_STATUS "(Status)"

typedef struct _eb_irc_lad
{
  int fd;
  char * nick;
  char * server;
  eb_pref_page * config_page;
  eb_contact * last_contact; // If we get an error about messaging, this is who we're talking about
  int input_tag;
  int ison_count;
  EList *ison_accum;
	char buffer[512];
	int buffer_size;
} eb_irc_lad;

typedef struct _eb_irc_gcd
{
  char * name;
  char * topic;
} eb_irc_gcd;

int eb_irc_init();
int eb_irc_finish();

int eb_irc_check(void * tag);

void eb_irc_incoming(void * tag, int source, int conditions);
char * eb_irc_read_cmd(int fd, int * line_end);
void eb_irc_ignore_line(int fd);
void eb_irc_parse_line(eb_local_account *ela, char *line);

void eb_irc_incoming_numeric(eb_local_account * ela, int code);

void eb_irc_process_message(eb_local_account * ela, char * from, char * target, char * msg);

eb_plugin_info irc_LTX_plugin_info = {"IRC chat", "Internet Relay Chat service", "(alpha)", "2002-09-26", eb_irc_init, eb_irc_finish};
static eb_service_callbacks callbacks;
eb_service irc_service_info = {"IRC", "Meredydd's IRC", &callbacks, SERVICE_CAN_GROUPCHAT|SERVICE_CAN_NAME_CHAT, "#8800dd", NULL, NULL, NULL, NULL};
EList * irc_states=NULL;

EList * owned_accounts=NULL;


void eb_irc_set_current_state(eb_local_account * ela, char * state);

void eb_irc_join_group_chat(eb_local_account * ela, char * name);

// eb_irc_init() and eb_irc_finish are at the bottom so I don't have to bother
// prototyping all these functions (lazy little $%& aren't I?)

void eb_irc_setup_local_account(eb_local_account * ela)
{
  eb_irc_lad * lad=(eb_irc_lad *)malloc(sizeof(eb_irc_lad));
  char * tmp;
  char * tmp2;

  lad->nick=strdup(eb_get_value(ela->config_key, "nick"));
  lad->ison_accum = NULL;
  lad->ison_count = 0;
	lad->buffer_size = 0;
  if(lad->nick[0]=='\0')
  {
    char * c;
    free(lad->nick);
    if((c=strstr(ela->handle, "@"))!=NULL)
    {
      *c='\0';
      lad->nick=strdup(ela->handle);
      lad->server=strdup(c+1);
      *c='@'; // change it back...

    } else {
      lad->nick=strdup(ela->handle);
      lad->server=strdup("irc.freenode.net");
    }
    eb_put_value(ela->config_key, "server", lad->server);
    eb_put_value(ela->config_key, "nick", lad->nick);
  } else {
    lad->server=strdup(eb_get_value(ela->config_key, "server"));
  }

  owned_accounts=e_list_append(owned_accounts, ela);
  ela->protocol_data=lad;
  lad->fd=-1;
  lad->last_contact=NULL;


  // Set up prefs page
  tmp=(char *)malloc(strlen(lad->nick)+strlen(lad->server)+16);
  tmp2=(char *)malloc(strlen(lad->nick)+strlen(lad->server)+16);
  sprintf(tmp, "%s on %s (IRC)", lad->nick, lad->server);
  sprintf(tmp2, "%s_IRC", ela->handle);
  lad->config_page=eb_make_pref_page(account_prefs, tmp2, tmp);
  free(tmp);
  free(tmp2);
  eb_add_component(lad->config_page, EB_PREF_LABEL, "name_lbl", ela->handle, registry, "params/dump", NULL, NULL);

  eb_add_component(lad->config_page, EB_PREF_TOGGLE, "excl_soa", "Exclude from \"Sign On All\"", ela->config_key, "excl_soa", NULL, NULL);

  eb_add_component(lad->config_page, EB_PREF_STRING, "server", "Server:", ela->config_key, "server", NULL, NULL);
  eb_put_default(ela->config_key, "port", "6667");
  eb_add_component(lad->config_page, EB_PREF_STRING, "port", "Port:", ela->config_key, "port", NULL, NULL);

  eb_add_component(lad->config_page, EB_PREF_STRING, "nick", "Nick (handle):", ela->config_key, "nick", NULL, NULL);
  eb_put_default(ela->config_key, "realname", "Everybuddy user");
  eb_add_component(lad->config_page, EB_PREF_STRING, "realname", "Real name:", ela->config_key, "realname", NULL, NULL);
  eb_add_component(lad->config_page, EB_PREF_TOGGLE, "status", "Show status messages", ela->config_key, "status", NULL, NULL);
}

void eb_irc_release_local_account(eb_local_account * ela)
{
  eb_irc_lad * lad=GET_LAD(ela);

  eb_destroy_pref_page(lad->config_page);
  owned_accounts=e_list_remove(owned_accounts, ela);

  free(lad->nick);
  free(lad->server);
  free(lad);
}

void eb_irc_login(eb_local_account * ela)
{
  if(atoi(eb_get_value(ela->config_key, "excl_soa")))
  { return; }

  eb_irc_set_current_state(ela, "Online");
}

void eb_irc_logout(eb_local_account * ela)
{
  eb_irc_lad * lad=GET_LAD(ela);
  EList * n;

  if(ela->connected)
  {
    char msg[]="QUIT :Everybuddy signing off\n";

    eb_input_remove( GET_LAD(ela)->input_tag );
    ewrite(lad->fd, msg, strlen(msg));
    close(lad->fd);
    lad->fd=-1;
  }

  free(ela->status_string);
  ela->status_string=strdup("Offline");

  for(n=ela->buddies; n!=NULL; n=n->next)
  {
    eb_account * acc=(eb_account *)n->data;

    if(acc->status!=EB_ACCOUNT_OFFLINE)
    { eb_buddy_logout(acc); }
  }

  for(n=ela->group_chats; n!=NULL; n=n->next)
  {
    eb_group_chat * chat=(eb_group_chat *)n->data;
    EList * n2;
    EList * queue=NULL;

    for(n2=chat->users; n2!=NULL; n2=n2->next)
    {
      queue=e_list_append(queue, n2->data);
    }

    for(n2=queue; n2!=NULL; n2=n2->next)
    {
      eb_group_chat_left(chat, ((eb_group_chat_user *)n2->data)->handle);
    }

    eb_group_chat_3rdperson(chat, "<font color=red><b><i>Connection to server lost");
  }

  ela->ready=0;
  ela->connected=0;

  eb_local_account_update(ela);
}

void eb_irc_status_send(eb_local_account *ela, char *text) {
	if (atoi(eb_get_value(ela->config_key, "status")))
	{
		eb_account *acc = eb_get_account(ela->handle, "IRC", IRC_STATUS);

    if(acc==NULL)
    {
      acc=eb_add_account_plus("IRC", IRC_STATUS, ela, IRC_STATUS);
      eb_buddy_login(acc);
    } else if(acc->status==EB_ACCOUNT_OFFLINE) {
      free(acc->status_string);
      acc->status_string=strdup("");
      eb_buddy_login(acc);
      eb_buddy_update_status(acc);
    }
    eb_incoming_message(acc, text);
	}
}

// Send msg to either user specified by contact_to or group chat specified by chat_to.
char * eb_irc_generic_send(eb_account * contact_to, eb_group_chat *chat_to, char *inmsg)
{
  char * tmp;
	eb_html_item *parsed = eb_html_parse(inmsg);
	char *msg = eb_html_render_plain(parsed);
  eb_local_account * account = chat_to?chat_to->account:contact_to->buddy_of;
  char * target = chat_to?(GET_GCD(chat_to)->name):(contact_to->handle);
  int fd = chat_to?(GET_LAD(chat_to->account)->fd):(GET_LAD(contact_to->buddy_of)->fd);
	eb_html_destroy(parsed);
	free(inmsg);
  
  /* Allowing users to send newlines is bad -- following text is interpreted by the server as a new command.
    This would be better handled by splitting at newlines and sending multiple messages. */
  for (tmp = msg; *tmp; tmp++) if (*tmp == '\n' || *tmp == '\r') *tmp = ' ';

	if(!strncmp(msg, "/join ", 6)) {
    eb_irc_join_group_chat(account, msg+6);
    free(msg);
    return NULL;
  } else if (contact_to && !strcmp(contact_to->handle, IRC_STATUS)) {
    tmp=(char *)malloc(strlen(msg) + 2);
    sprintf(tmp, "%s\n", msg);
    ewrite(fd, tmp, strlen(tmp));
    free(tmp);
    free(msg);
    return NULL;
	} else if(!strncmp(msg, "/me ", 4)) {
    tmp=(char *)malloc(strlen(msg)+strlen(target)+strlen(account->handle)+32);
    sprintf(tmp, "PRIVMSG %s :\001ACTION %s\001\n", target, msg+4);
    ewrite(fd, tmp, strlen(tmp));
    sprintf(tmp, "<font color=#8800dd><b>%s</b></font> %s</i>",
      account->handle, msg+4);
    if (chat_to) eb_group_chat_3rdperson(chat_to, tmp);
    if (contact_to) eb_notify_3rdperson(contact_to->contact, tmp);
    free(tmp);
    free(msg);
    return NULL;
  } else if (chat_to && !strncmp(msg, "/topic ", 7)) { // Wouldn't hurt to allow /topic #<channel> <topic>, too
    tmp=(char *)malloc(strlen(msg)+strlen(target)+32);
    sprintf(tmp, "TOPIC %s :%s\n", target, msg+7);
    ewrite(fd, tmp, strlen(tmp));
    free(tmp);
    free(msg);
    return NULL;
  } else if (!strncmp(msg, "/raw ", 5)) {
    tmp=(char *)malloc(strlen(msg) - 3);
    sprintf(tmp, "%s\n", msg+5);
    ewrite(fd, tmp, strlen(tmp));
    free(tmp);
    free(msg);
    return NULL;
  } else {
    tmp=(char *)malloc(strlen(msg)+strlen(target)+32);
    sprintf(tmp, "PRIVMSG %s :%s\n", target, msg);
    ewrite(fd, tmp, strlen(tmp));
    free(tmp);
    return msg;
  }
}

char * eb_irc_send_im(eb_account * to, char * message)
{
  if(!to->buddy_of->ready)
  {
		eb_show_error("Cannot send messages from an offline account", "IRC error");
		free(message);
		return NULL;
	}

  return eb_irc_generic_send(to, 0, message);
}

void eb_irc_send_data_message(eb_account * to, char * filename, char * contenttype, char * disposition, int reported_length)
{
  int hlen=500-strlen(to->handle);
  if(!strcmp(disposition, "inline") && reported_length<5*(hlen-12)*3/4)
  {
    char * buf[5];
    int a, num_msg;
    char sendbuf[512];
    
    for(a=0; a<5; a++) { buf[a]=(char *)malloc(512); }
    
    eb_package_inlined_data(filename, contenttype, reported_length, hlen,  buf, &num_msg);
    
    sprintf(sendbuf, "PRIVMSG %s :%s\n");
    for(a=0; a<num_msg; a++)
    {
      ewrite(GET_LAD(to->buddy_of)->fd, sendbuf, strlen(sendbuf));
    }
    free(sendbuf);
  
    for(a=0; a<5; a++) { free(buf[a]); }
    
    eb_sent_inline_data_message(to, filename, contenttype);
    
    return;
  }
  
  eb_notify_3rdperson(to->contact, "<font color=red><i>IRC cannot yet send large or non-inlined data messages");
}

void eb_irc_del_user(eb_account * acc)
{
  eb_destroy_inlined_data_state((eb_inlined_data_state *)acc->protocol_data);
}

void eb_irc_join_group_chat(eb_local_account * ela, char * name)
{
  char * tmp;

  if(name[0]!='#' && name[0]!='&')
  { eb_show_error("Not a valid channel name - IRC channel names must begin with a hash or ampersand ('#' or '&'), for example \"#everybuddy\"", "IRC error"); return; }

  tmp=(char *)malloc(strlen(name)+32);
  sprintf(tmp, "JOIN %s\n", name);
  ewrite(GET_LAD(ela)->fd, tmp, strlen(tmp));
  free(tmp);
}

void eb_irc_leave_group_chat(eb_group_chat * chat)
{
  char * tmp;

  if(chat->account->ready)
  {
    tmp=(char *)malloc(strlen(GET_GCD(chat)->name)+16);
    sprintf(tmp, "PART %s\n", GET_GCD(chat)->name);
    ewrite(GET_LAD(chat->account)->fd, tmp, strlen(tmp));
    free(tmp);
  }

  eb_destroy_group_chat(chat);
}

char * eb_irc_group_chat_send(eb_group_chat * chat, char *msg)
{
  if(strlen(msg)>=500)
  {
    eb_group_chat_3rdperson(chat, "<font color=#ff0000><i><b>Warning:</b> IRC messages must be under 500 characters long. This message has been truncated:</i></font>");
    msg[500]='\0';
  }

  return eb_irc_generic_send(0, chat, msg);
}

void eb_irc_set_current_state(eb_local_account * ela, char * state)
{
  if(!strcmp(state, "Online"))
  {
    eb_irc_lad * lad=GET_LAD(ela);
    char * server=eb_get_value(ela->config_key, "server");
    int port=atoi(eb_get_value(ela->config_key, "port"));
    char * nick=eb_get_value(ela->config_key, "nick");
    char * realname=eb_get_value(ela->config_key, "realname");
    char * tmp;

    if(ela->connected) { return; }

    printf("IRC login has begun!\n");

    if(port==0) { eb_show_error("No port specified!", "IRC"); return; }

    printf("Connecting to %s:%d\n", server, port);

    ela->connected=1;
    eb_local_account_update(ela);

    lad->fd=eb_connect_sync_socket(server, port);
    if(lad->fd==-1)
    {
      char * buf=(char *)malloc(strlen(server)+64);
      ela->connected=0;
      eb_local_account_update(ela);
      sprintf(buf, "Connection to %s:%d failed", server, port);
      eb_show_error(buf, "IRC error");
      free(buf);
      return;
    }

    lad->input_tag=eb_input_add(lad->fd, EB_INPUT_READ, eb_irc_incoming, ela);

    tmp=(char *)malloc(strlen(nick)*2+strlen(server)+strlen(realname)+32);
    sprintf(tmp, "NICK %s\nUSER %s 0 * :%s\n", nick, nick, realname);
    ewrite(lad->fd, tmp, strlen(tmp));
    free(tmp);
  }

  if(!strcmp(state, "Offline"))
  {
    if(ela->connected) { eb_irc_logout(ela); }
  }

  if(!strcmp(state, "Away"))
  { eb_show_error("Sorry, the Away state is not yet supported", "IRC error"); }
}

void eb_irc_set_away(eb_local_account * ela, char * short_msg, char * long_msg)
{
}

void eb_irc_unset_away(eb_local_account * ela)
{
}

int eb_irc_init()
{
  printf("Loading IRC module (such as it is...)\n");

  memset(&callbacks, 0, sizeof(callbacks));
  callbacks.setup_local_account=eb_irc_setup_local_account;
  callbacks.release_local_account=eb_irc_release_local_account;
  // no setup or release is required for buddy accounts

  callbacks.login=eb_irc_login;
  callbacks.logout=eb_irc_logout;
  callbacks.send_im=eb_irc_send_im;

  callbacks.set_current_state=eb_irc_set_current_state;
  callbacks.set_away=eb_irc_set_away;
  callbacks.unset_away=eb_irc_unset_away;
  // no add_ or remove_ user calls needed either (three cheers for simplicity!)
  // no concept of block, unblock, or grouping, so no such calls necessary
  
  // Oh, scratch that, del_user is needed to clean up any inline data transfers
  callbacks.del_user=eb_irc_del_user;

  callbacks.group_chat_send=eb_irc_group_chat_send;
  callbacks.join_group_chat=eb_irc_join_group_chat;
  callbacks.leave_group_chat=eb_irc_leave_group_chat;

  irc_states=e_list_append(irc_states, strdup("Online"));
  irc_states=e_list_append(irc_states, strdup("Away"));
  irc_states=e_list_append(irc_states, strdup("Offline"));
  irc_service_info.states=irc_states;

  eb_load_service(&irc_service_info);

  eb_set_timer(eb_irc_check, 1, NULL);

  return 0;
}

int eb_irc_finish()
{
  printf("IRC module packing its bags\n");
  return 0;
}

int eb_irc_check(void * tag)
{
  EList * accs;
  for(accs=owned_accounts; accs!=NULL; accs=accs->next)
  {
    eb_local_account * ela=(eb_local_account *)accs->data;
    eb_irc_lad * lad=GET_LAD(ela);

    if(!ela->ready) { continue; }
    else
    {
      char buffer[512];
      char *pos = buffer;
      EList * buddy = ela->buddies;

      lad->ison_count = 0;

      while (1) // Send all of the ISON requests at once, broken up into multiple sends to avoid exceeding line-length limits
      {
        if (pos == buffer)
        {
          strcpy(buffer, "ISON :");
          pos = buffer+6;
        }
        if (buddy)
        {
          char *nick = ((eb_account *)buddy->data)->handle;
          int too_long = pos - buffer + strlen(nick) + 7 > 500; /* 500 == magic number.  Change me. */

          if (!too_long && strcmp(nick, IRC_STATUS))
          {
            strcpy(pos, nick);
            pos += strlen(nick);
            *pos++ = ' ';
          }
          if (too_long || !buddy->next) // We need to send what we have so far
          {
            *(pos-1) = '\n'; // Replace a space with a newline (tricky)
            *pos++ = '\0';
            ewrite(lad->fd, buffer, pos - buffer - 1);
            pos = buffer;
            lad->ison_count++;
            if (too_long) continue; // Don't advance buddy yet
          }
        } else break;
        buddy = buddy->next;
      }
    }
  }

  return 30;
}

eb_group_chat * eb_irc_get_chat(eb_local_account * acc, char * name)
{
  EList * n;

  for(n=group_chats; n!=NULL; n=n->next)
  {
    eb_group_chat * chat=(eb_group_chat *)n->data;
    if(chat->account!=acc) { continue; }

    if(!strcasecmp(GET_GCD(chat)->name, name)) { return chat; }
  }

  return NULL;
}

/*void eb_irc_trim_nick(char * s)
{
  int pos=0;

  while(1)
  {
    if(s[pos]=='!') { s[pos]='\0'; return; }
    if(s[pos]=='\0') { return; }
    pos++;
  }
}*/

int eb_irc_parse_params(char *line, char ***params)
{
	int count = 0;
	char *prev = line;

	while (1)
	{
		if (*line == ' ' || *line == '\0' || *prev == ':')
		{
			// This is all rather ugly.  std::vector.push_back(foo) is what it amounts to.
			//  However, it should make the rest of the parsing oh so much easier.
			char **new = (char **)realloc(*params, (count + 1) * sizeof(char *));
			int last = 0;
			count++;

			if (*prev == ':')
			{
				prev++;
				last = 1;
			}
			else if (*line == '\0')
			{
				last = 1;
			}
			else if (*line == ' ')
			{
				*line++ = '\0';
			}
			
			if (!new)
			{
				fprintf(stderr, "Unable to realloc memory in eb_irc_parse_params.  Bailing out.\n");
				free(*params);
				*params = 0;
				return 0;
			}

			*params = new;
			(*params)[count - 1] = prev;
			prev = line;
			
			if (last)
			{
				break;
			}
		}
		else
		{
			line++;
		}
	}

	return count;
}

int eb_irc_parse_numeric(eb_local_account *ela, int command, char **argv, int argc)
{
	int processed = 0;

	eb_irc_lad *lad = GET_LAD(ela);
	if (command == 401) // No such user/channel
	{
		eb_account *acc = eb_get_account(ela->handle, "IRC", argv[0]);
		if (acc)
		{
			processed = 1;
			eb_notify_3rdperson(acc->contact, "<font color=red><i><b>Warning:</b> Your last message failed, because the user has logged off from IRC.</i></font>");
		}
	}
	else if (command >= 400 && command < 500) // Error
	{
		processed = 1;
		eb_show_error(argv[argc - 1], "IRC Error");
	}
	else if (command == 1) // ???
	{
    EList * n;

    ela->ready=1;
    free(ela->status_string);
    ela->status_string=strdup("Online");
    eb_local_account_update(ela);

    for(n=ela->group_chats; n!=NULL; n=n->next)
    {
      eb_group_chat * chat=(eb_group_chat *)n->data;

      eb_irc_join_group_chat(ela, chat->title);
    }
		processed = 1;
	}
	else if (command == 303)
	{
    EList *accum = lad->ison_accum;
		char **nicks = 0;
		int count = eb_irc_parse_params(argv[argc-1], &nicks);

		while (count--)
		{
			accum = e_list_append(accum, strdup(nicks[count]));
		}

    if (!(--lad->ison_count))
    {
      EList *buddy;

      for (buddy = ela->buddies; buddy != NULL; buddy = buddy->next)
      {
        eb_account *acc = (eb_account *)buddy->data;
        EList *ison;
        int found = 0;

        for (ison = accum; ison != NULL; ison = ison->next)
        {
          if (!strcasecmp(ison->data, acc->handle))
          {
            found = 1;
            if (acc->status==EB_ACCOUNT_OFFLINE)
            {
              free(acc->status_string);
              acc->status_string=strdup("");
              eb_buddy_login(acc);
              eb_buddy_update_status(acc);
              break;
            }
          }
        }
        if (!found && acc->status!=EB_ACCOUNT_OFFLINE && strcmp(acc->handle, IRC_STATUS))
        {
          free(acc->status_string);
          acc->status_string=strdup("(Offline)");
          eb_buddy_logout(acc);
          eb_buddy_update_status(acc);
        }
      }

      e_list_free(accum);
    	lad->ison_accum = 0;
			processed = 1;
		}
	}
	else if (command == 332 || command == 331) // RPL_TOPIC
	{
		if (argc >= 3)
		{
			eb_group_chat *chat = eb_irc_get_chat(ela, argv[1]);

			if (chat)
			{
				free(GET_GCD(chat)->topic);
				GET_GCD(chat)->topic=strdup(argv[2]);
				processed = 1;
			}
		}
	}
	else if (command == 353) // RPL_NAMEREPLY
	{
		if (argc > 1)
		{
			eb_group_chat *chat = eb_irc_get_chat(ela, argv[argc-2]);
			char **names = 0;
			int count = eb_irc_parse_params(argv[argc-1], &names);
			int i;
			printf("names: %s\n", argv[argc - 1]);
			for (i = 0; i < count; i++)
			{
				char *start = names[i];
				printf("name: %s\n", names[i]);
				while (*start == '@' || *start == '+') start++;
				// TODO: flag them as op/voiced, if possible
				eb_group_chat_joined(chat, start);
			}
			free(names);
			processed = 1;
		}
	}
	else if (command == 366) // RPL_ENDOFNAMES
	{
		if (argc > 0)
		{
			eb_group_chat *chat = eb_irc_get_chat(ela, argv[1]);
			if (chat)
			{
				char *tmp=(char *)malloc(strlen(GET_GCD(chat)->topic)+64);
				eb_announce_group_chat(chat);
	    	sprintf(tmp, "<i>Topic for today:</i>\n<font color=#4444ff>%s</font>\n", GET_GCD(chat)->topic);
		    eb_group_chat_3rdperson(chat, tmp);
		    free(tmp);
				processed = 1;
			}
		}
	}
	else
	{
		if (argc > 2)
		{
			char buffer[512];
			int i;
			strcpy(buffer, argv[1]);
			for (i = 2; i < argc; i++)
			{
				if (i == argc - 1) strcat(buffer, ":");
				strcat(buffer, " ");
				strcat(buffer, argv[i]);
			}
			eb_irc_status_send(ela, buffer);
		}
		else
		{
			eb_irc_status_send(ela, argv[argc - 1]);
		}

		processed = 1;
	}

	return processed;
}

int eb_irc_parse_text(eb_local_account *ela, char *command, char **argv, int argc, char *nick, char *user, char *host)
{
	int processed = 0;

	if (!strcmp(command, "JOIN"))
	{
		eb_group_chat * chat;
    eb_account * buddy;
		if (argc < 1) return 0;
    chat=eb_irc_get_chat(ela, argv[0]);

    if(chat==NULL)
    {
      chat=eb_create_group_chat(ela);
      chat->protocol_data=(eb_irc_gcd *)malloc(sizeof(eb_irc_gcd));
      chat->title=strdup(argv[0]);
      GET_GCD(chat)->name=strdup(argv[0]);
      GET_GCD(chat)->topic=strdup("No topic set");
    }

    if(chat->announced)
    {
      char *buf=(char *)malloc(strlen(nick)+64);
      sprintf(buf, "<font color=#666666><i><b>%s</b> has joined the channel", nick);
      eb_group_chat_3rdperson(chat, buf);
      free(buf);
      eb_group_chat_joined(chat, nick);
    }

    // Now check whether the recent joiner is on our buddy list, and sign them in
    // - if they've joined a channel with us, they're online
    buddy=eb_get_account(ela->handle, ela->service_name, nick);
    if (buddy!=NULL)
    {
      if (buddy->status==EB_ACCOUNT_OFFLINE)
      {
        free(buddy->status_string);
        buddy->status_string=strdup("");
        eb_buddy_login(buddy);
        eb_buddy_update_status(buddy);
      }
    }

		processed = 1;
	}
	else if (!strcmp(command, "PART"))
	{
    eb_group_chat * chat;
		if (argc < 1) return 0;

    chat=eb_irc_get_chat(ela, argv[0]);

    if (chat)
    {
      char * buf=(char *)malloc(strlen(nick)+64);
      sprintf(buf, "<font color=#666666><i><b>%s</b> has left the channel", nick);
      eb_group_chat_3rdperson(chat, buf);
      free(buf);
      eb_group_chat_left(chat, nick);

			processed = 1;
    }
	}
	else if (!strcmp(command, "NICK"))
	{
    eb_account * buddy;
    EList * n;

		if (argc < 1) return 0;

    for (n=group_chats; n!=NULL; n=n->next)
    {
      eb_group_chat * chat=(eb_group_chat *)n->data;
      EList * n2;

      for (n2=chat->users; n2!=NULL; n2=n2->next)
      {
        eb_group_chat_user * user=(eb_group_chat_user *)n2->data;

        if (!strcmp(user->handle, nick))
        {
          char * buf=(char *)malloc(strlen(argv[0])+strlen(nick)+64);
          sprintf(buf, "<font color=#666666><i><b>%s</b> is now known as <b>%s</b>", nick, argv[0]);
          eb_group_chat_3rdperson(chat, buf);
          free(buf);

          eb_group_chat_left(chat, nick);
          eb_group_chat_joined(chat, argv[0]);
          break;
        }
      }
    }

    buddy=eb_get_account(ela->handle, "IRC", nick);
    if(buddy!=NULL && buddy->status!=EB_ACCOUNT_OFFLINE)
    {
			buddy->status=EB_ACCOUNT_OFFLINE;
			eb_buddy_logout(buddy);
		}		

    buddy=eb_get_account(ela->handle, "IRC", argv[0]);
    if (buddy!=NULL && buddy->status==EB_ACCOUNT_OFFLINE)
    { 
      free(buddy->status_string);
      buddy->status_string=strdup("");
      eb_buddy_login(buddy);
      eb_buddy_update_status(buddy);
    }
		processed = 1;
  } else if(!strcmp(command, "TOPIC")) {
		if (argc >= 2)
		{
	    eb_group_chat * chat=eb_irc_get_chat(ela, argv[0]);
	    char * tmp;

			if (!chat) return 0;

	    tmp=(char *)malloc(strlen(nick)+strlen(argv[0])+strlen(argv[1])+128);
	    sprintf(tmp, "<i>%s has changed the topic of %s to:<br><font color=#4444ff>%s</font></i>", nick, argv[0], argv[1]);
	    eb_group_chat_3rdperson(chat, tmp);
	    free(tmp);

	    free(GET_GCD(chat)->topic);
	    GET_GCD(chat)->topic=strdup(argv[1]);
			processed = 1;
		}
	}
	else if (!strcmp(command, "QUIT"))
	{
    eb_account * buddy;
    EList * n;

    for(n=group_chats; n!=NULL; n=n->next)
    {
      eb_group_chat * chat=(eb_group_chat *)n->data;
      EList * n2;

      for(n2=chat->users; n2!=NULL; n2=n2->next)
      {
        eb_group_chat_user * user=(eb_group_chat_user *)n2->data;

        if(!strcmp(user->handle, nick))
        {
          // cmb: can't figure out why, but second works, first doesn't!
          //      (doesn't as in tells me 'testquit' for 'cmb|testquit')
          //eb_group_chat_left(chat, user->handle);
          char * buf=(char *)malloc(strlen(nick)+64);
          sprintf(buf, "<font color=#666666><i><b>%s</b> has quit IRC", nick);
          eb_group_chat_3rdperson(chat, buf);
          free(buf);

          eb_group_chat_left(chat, nick);
          break;
        }
      }
    }

    buddy=eb_get_account(ela->handle, "IRC", nick);
    if(buddy!=NULL && buddy->status!=EB_ACCOUNT_OFFLINE)
    {
			buddy->status=EB_ACCOUNT_OFFLINE;
			eb_buddy_logout(buddy);
		}
		processed = 1;
	}
	else if (!strcmp(command, "PRIVMSG"))
	{
		if (argc == 2 && nick)
		{
	    eb_irc_process_message(ela, nick, argv[0], argv[1]);
			processed = 1;
		}
	}
	else if (!strcmp(command, "NOTICE"))
	{
		if (argc == 2 && nick) // Throwing away the fact that it was a notice...sigh.
		{
	    eb_irc_process_message(ela, nick, argv[0], argv[1]);
			processed = 1;
		}
	}
	else if (!strcmp(command, "PING"))
	{
		if (argc > 0)
		{
	    char * tmp=(char *)malloc(strlen(argv[0])+16);
	    sprintf(tmp, "PONG %s\n", argv[0]);
	    ewrite(GET_LAD(ela)->fd, tmp, strlen(tmp));
	    free(tmp);
			processed = 1;
		}
	}
	else if (!strcmp(command, "ERROR"))
	{
		if (argc > 0)
		{
			char buffer[512];
			sprintf(buffer, "%s: %s", argv[1], argv[0]);
	    eb_show_error(argv[argc-1], "IRC error");
	    eb_irc_logout(ela);
			processed = 1;
		}
	}
	else if (!strcmp(command, "KICK"))
	{
    eb_group_chat * chat;
		if (argc < 1) return 0;

    chat=eb_irc_get_chat(ela, argv[0]);

    if (chat)
    {
      char * buf=(char *)malloc(strlen(nick)+64);
      sprintf(buf, "<font color=#666666><i><b>%s</b> was kicked by %s (%s)", argv[0], nick, (argc>0)?argv[1]:"");
      eb_group_chat_3rdperson(chat, buf);
      free(buf);
      eb_group_chat_left(chat, nick);
			processed = 1;
    }
	}

	return processed;
}

void eb_irc_parse_line(eb_local_account *ela, char *line)
{
	eb_irc_lad *lad = GET_LAD(ela);
	char *nick = 0; // Also server name.
	char *user = 0;
	char *host = 0;
	char **params = 0;
	char *original = strdup(line);
	int param_count;
	int processed = 0;

	//printf("IRC Incoming: %s\n", line);

	//printf("Line = %d\n", line);

	if (*line == ':')
	{
		nick = line + 1;

		while (*line != ' ' && *line != '\0')
		{
			if (*line == '!')
			{
				user = line + 1;
				*line = '\0';
			}

			if (*line == '@')
			{
				host = line + 1;
				*line = '\0';
			}
			line++;
		}
		*line++ = '\0';
	}

	param_count = eb_irc_parse_params(line, &params);

	//printf("Nickname = %s, user = %s, host = %s, message = %s, param_count = %d\n", nick?nick:"", user?user:"", host?host:"", line?line:"", param_count);
	
	if (param_count > 0) // Gosh, I hope so...
	{
		if (isdigit(params[0][0]))
		{
			int command;
			sscanf(params[0], "%d", &command);

			processed = eb_irc_parse_numeric(ela, command, &params[1], param_count - 1);
		}
		else
		{
			processed = eb_irc_parse_text(ela, params[0], &params[1], param_count - 1, nick, user, host);
		}
	}

	if (!processed) eb_irc_status_send(ela, original);
	
	free(params);
	free(original);
}

void eb_irc_incoming(void * tag, int fd, int conditions)
{
  eb_local_account *ela=(eb_local_account *)tag;
	eb_irc_lad *lad = GET_LAD(ela);
	ssize_t result = 1;
	int ready = ela->ready;
	
	if ((ela->ready || !ready))
	{
		int pos;
		int repeat = 1;

		result = read(fd, lad->buffer + lad->buffer_size, 512 - lad->buffer_size);

		if (result < 0) // bail
		{
			eb_irc_logout(ela);
			return;
		}

		lad->buffer_size += result;

		while (repeat && (ela->ready || !ready))
		{
			repeat = 0;

			for (pos = 0; pos < lad->buffer_size; pos++)
			{
				if (lad->buffer[pos] == '\r' || lad->buffer[pos] == '\n' || lad->buffer[pos] == '\0')
				{
					lad->buffer[pos] = '\0';
					eb_irc_parse_line(ela, lad->buffer);
					while (pos < lad->buffer_size && (lad->buffer[pos] == '\r' || lad->buffer[pos] == '\n' || lad->buffer[pos] == '\0'))
					{
						lad->buffer[pos++] = '\0';
					}
					memmove(lad->buffer, &lad->buffer[pos], lad->buffer_size - pos);
					lad->buffer_size -= pos;
					repeat = 1;
					break;
				}
			}
		}
	}
}

void eb_irc_process_message(eb_local_account * ela, char * from, char * target, char * msg)
{
  eb_group_chat * chat=eb_irc_get_chat(ela, target);
  eb_account * acc=NULL;
  int start=0;
  int pos=0;

  if(chat==NULL)
  {
    acc=eb_get_account(ela->handle, "IRC", from);
    if(acc==NULL)
    {
      acc=eb_add_account_plus("Unknown", from, ela, from);
      eb_buddy_login(acc);
    } else if(acc->status==EB_ACCOUNT_OFFLINE) {
      // they msged us, they're online
      free(acc->status_string);
      acc->status_string=strdup("");
      eb_buddy_login(acc);
      eb_buddy_update_status(acc);
    }
  }

  // OK, now let's get parsing!

  while(msg[pos]!='\0')
  {
    start=pos;

    while(1)
    {
      pos++;
      if(msg[pos]=='\0' || msg[pos]==1) { break; }
    }

    // OK, now start is at the beginning of this segment, and pos is at the end.
    if(msg[start]==1 && msg[pos]==1) // CTCP
    {
      int end = start + 1;

      // Process it a little...turn a string like "\1PING 2345\1" into "\1PING\02345\0"
       //  msg+start+1 is the start of PING and msg+end is the start of 2345 /
      msg[pos] = '\0';
      while (end + 1 <= pos && msg[end + 1] != ' ' && msg[end + 1]) end++;
      if (end < pos) end++;
      msg[end] = '\0';
      if (end < pos) end++;

      if(!strcmp(msg+start+1, "ACTION"))
      {
        char * buf=strdup(msg+end);
        char html_buf[1024]; // fixed size justified because of IRC line length limits

        if(msg[pos]==1) { pos++; }

        if(chat!=NULL)
        {
          buf=eb_filter_string(EB_GROUP_FILTER_IN, buf, chat);
          if(buf==NULL) { continue; }
          sprintf(html_buf, "<font color=#8800dd><b>%s</b></font> %s", from, buf);
          eb_group_chat_3rdperson(chat, html_buf);
        } else {
          buf=eb_filter_string(EB_FILTER_IN, buf, acc);
          if(buf==NULL) { continue; }
          sprintf(html_buf, "<font color=#8800dd><b>%s</b></font> %s",
            acc->contact->name, buf);
          eb_notify_3rdperson(acc->contact, html_buf);
        }

        free(buf);
        continue;
      } else if (!strcmp(msg+start+1, "PING")) {
        char buf[512];
        size_t len;
        msg[pos] = '\0';
        len = sprintf(buf, "NOTICE %s :\001PING %s\001\n", from, msg+end);
        ewrite(GET_LAD(ela)->fd, buf, len);
        if(msg[pos]==1) { pos++; }
        continue;
      } else if (!strcmp(msg+start+1, "VERSION")) {
        char buf[512];
        size_t len;
        len = sprintf(buf, "NOTICE %s :\001VERSION %s\001\n", from, PACKAGE " " VERSION);
        ewrite(GET_LAD(ela)->fd, buf, len);
        if(msg[pos]==1) { pos++; }
        continue;
      } else if (!strcmp(msg+start+1, "CLIENTINFO")) {
        char buf[512];
        size_t len;
        len = sprintf(buf, "NOTICE %s :\001CLIENTINFO PING VERSION CLIENTINFO USERINFO\001\n", from);
        ewrite(GET_LAD(ela)->fd, buf, len);
        if(msg[pos]==1) { pos++; }
        continue;
      } else if (!strcmp(msg+start+1, "USERINFO")) {
        char buf[512];
        size_t len;
        len = sprintf(buf, "NOTICE %s :\001USERINFO %s\001\n", from, eb_get_value(ela->config_key, "realname"));
        ewrite(GET_LAD(ela)->fd, buf, len);
        if(msg[pos]==1) { pos++; }
        continue;
      }

      // If we get here, it's an unrecognised type of CTCP. Complain. Loudly.

      if(msg[pos]==1) { pos++; }
      if(chat)
      {
        eb_group_chat_3rdperson(chat, "<font color=red><b>** Received unknown CTCP command, ignoring it.</b></font><br>");
      } else {
        eb_notify_3rdperson(acc->contact, "<font color=red><b>** Received unknown CTCP command, ignoring it.</b></font><br>");
      }

    } else { // normal message
      char * buf=(char *)malloc(512);

      strncpy(buf, msg+start, pos-start);
      buf[pos-start]='\0';


      if(chat!=NULL)
      {
        buf=eb_filter_string(EB_GROUP_FILTER_IN, buf, chat);
        if(buf==NULL) { continue; }
        eb_group_chat_message(chat, from, buf);
      } else {
        if(!strncmp(buf, "EB+]#[", 6)) // inlined transfer
        {
          if(eb_handle_inlined_data(acc, buf, strlen(buf),
            (eb_inlined_data_state **)&(acc->protocol_data))==0)
          { free(buf); return; }
        }
      
        buf=eb_filter_string(EB_FILTER_IN, buf, acc);
        if(buf==NULL) { continue; }
        eb_incoming_message(acc, buf);
      }

      free(buf);
    }
  }
}
