#include <stdio.h>
#include <stdlib.h>
#ifndef __MINGW32__
#include <sys/poll.h>
#endif

#include "eb-cmd.h"
#include "GUIcomms.h"

// Send an instant message using Everybuddy

main(int argc, char * argv[])
{
  int a, b, len=0;
  char * group=NULL;
  char * contact=NULL;
  char * service="";
  char * message;
  char * cmd[]={"message_send", NULL, NULL, "", NULL, "", NULL};

  for(a=1; a<argc; a++)
  {
    if(!strcmp(argv[a], "-g"))
    {
      if(a+1==argc) { printf("Not enough arguments - see --help for details\n"); break; }
      group=argv[++a];
      continue;
    }

    if(!strcmp(argv[a], "-s"))
    {
      if(a+1==argc) { printf("Not enough arguments - see --help for details\n"); break; }
      service=argv[++a];
      continue;
    }

    if(!strcmp(argv[a], "-h") || !strcmp(argv[a], "--help"))
    {
      printf("Usage: eb-send [-g group] [-s service] contact message\n"
      "  --help, -h\n\tPrints this message and exits successfully\n"
      "  -g GROUP\n\tSpecify which group the contact you wish to contact is in\n\t(in case of duplicates)\n"
      "  -s SERVICE\n\tSpecify which service (eg MSN) should be used to send\n\tthe message. Case-sensitive - use eb-ctl -s to list the options\n"
      );
      exit(0);
    }

    // OK, we've hit an unknown option. That'll be the contact name...
    break;
  }

  if(a+1>=argc)
  { printf("No message specified!\n"); exit(1); }

  contact=argv[a++];

  eb_cmd_connect();

  eb_cmd_getmsgs();

  if(group==NULL)
  {
    group=eb_cmd_get_group(contact);

    if(group==NULL)
    {
      fprintf(stderr, "Contact \"%s\" not found\n", contact);
      exit(1);
    }

  }

  for(b=a; b<argc; b++)
  {
    len+=strlen(argv[b])+1;
  }

  message=(char *)malloc(len);
  for(b=a; b<argc; b++)
  {
    if(b==a)
    {
      strcpy(message, argv[b]);
    } else {
      strcat(message, " ");
      strcat(message, argv[b]);
    }
  }

  cmd[1]=group;
  cmd[2]=contact;
  cmd[4]=service;
  cmd[6]=message;

  send_gui_message(cmd, 7);


  while(1)
  {
    int num_parms;
    char ** rcmd=read_gui_message(&num_parms);
    fflush(stdout);

    if(!strcmp(rcmd[0], "client_error"))
    {
      fprintf(stderr, "Error: %s\n", rcmd[1]);
      break;
    }

    if(!strcmp(rcmd[0], "error_dialog"))
    {
      char * resolve_cmd[]={"resolve_dialog", rcmd[1]};
      fprintf(stderr, "%s: %s\n", rcmd[2], rcmd[3]);
      send_gui_message(resolve_cmd, 2);
      break;
    }

    if(!strcmp(rcmd[0], "message_send") || !strcmp(rcmd[0], "holding_message"))
    {
      printf("Message sent.\n");
      break;
    }
  }

}

