#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef __MINGW32__
#include <sys/poll.h>
#endif

#include "eb-cmd.h"
#include "GUIcomms.h"

// Send an instant message using Everybuddy

void eb_ctl_list(int online_only);
void eb_ctl_services(void);
void eb_ctl_status(void);

main(int argc, char * argv[])
{
  char * command;

  eb_cmd_connect();

  if(argc<2) { fprintf(stderr, "No parameters given! \"eb-ctl help\" for help\n"); return 1; }
  command=argv[1];

  if(!strcmp(command, "help"))
  {
    printf("Usage: eb-ctl <command> ...\nPossible commands:\n"
    "  help\n\tPrints this message and exits successfully\n"
    "  list [online]\n\tPrints the contact list (groups and contacts only). If \"online\"\nis specified, ony online contacts are printed.\n"
    "  services\n\tPrints the list of services supported by this core\n"
    "  status\n\tPrints the status of all local accounts\n"
    "  ignore [GROUP] CONTACT \"MESSAGE\"\n\tIgnore CONTACT with MESSAGE (specifying the group is optional)\n"
    "  away SHORT \"LONG\"\n\tSets an away message with the short summary SHORT, and the auto-response\nLONG\n"
    "  hold\n\tTurns on message hold\n"
    "  signon\n\tSigns on all accounts\n"
    "  signoff\n\tSigns off all accounts\n");

    exit(0);
  }

  if(!strcmp(command, "list"))
  {
    eb_ctl_list(argc==3 && !strcmp(argv[2], "online"));
    exit(0);
  }

  if(!strcmp(command, "services"))
  {
    eb_ctl_services();
    exit(0);
  }

  if(!strcmp(command, "status"))
  {
    eb_ctl_status();
    exit(0);
  }

  if(!strcmp(command, "hold"))
  {
    char * cmd[]={"message_hold", "1"};
    send_gui_message(cmd, 2);
    exit(0);
  }

  if(!strcmp(command, "nohold"))
  {
    char * cmd[]={"message_hold", "0"};
    send_gui_message(cmd, 2);

    printf("Message hold deactivated. If there is another user interface\nconnected to this core, eb-recv can no longer receive messages\nwithout the \"wait\" option.\n");

    exit(0);
  }

  if(!strcmp(command, "ignore"))
  {
    char * contact;
    char * group;
    char * cmd[]={"ignore_contact", NULL, NULL, NULL};

    if(argc>5 || argc<4)
    {
      fprintf(stderr, "Usage: eb-ctl ignore [GROUP] CONTACT \"MESSAGE\"\neb-ctl help for details\n");
      exit(1);
    }

    if(argc==4)
    {
      contact=argv[2];
      group=eb_cmd_get_group(contact);
      if(group==NULL)
      { fprintf(stderr, "Contact \"%s\" not found\n", contact); exit(1); }
      cmd[3]=argv[3];
    } else {
      group=argv[2];
      contact=argv[3];
      cmd[3]=argv[4];
    }

    cmd[1]=group;
    cmd[2]=contact;
    send_gui_message(cmd, 4);
  }

  if(!strcmp(command, "away"))
  {
    char * cmd[]={"set_away", NULL, NULL};
    if(argc!=4)
    {
      fprintf(stderr, "Usage: eb-ctl away \"SHORT\" \"LONG\"\neb-ctl help for details\n");
      exit(1);
    }
    cmd[1]=argv[2];
    cmd[2]=argv[3];
    send_gui_message(cmd, 3); 
    exit(0);
  }

  if(!strcmp(command, "signon"))
  {
    char * cmd[]={"sign_on_all"};
    send_gui_message(cmd, 1);
    exit(0);
  }

  if(!strcmp(command, "signoff"))
  {
    char * cmd[]={"sign_off_all"};
    send_gui_message(cmd, 1);
    exit(0);
  }

  fprintf(stderr, "Command \"%s\" not recognised - eb-ctl help for details\n", command);
  exit(1);
}

void eb_ctl_list(int online_only)
{
  char * list_cmd[]={"list_contacts"};
  char * last_contact=NULL;
  char * last_online=NULL;

  send_gui_message(list_cmd, 1);

  while(1)
  {
    int n;
    char ** rcmd=read_gui_message(&n);

    if(!strcmp(rcmd[0], "list_contacts_done"))
    {
      if(last_contact!=NULL)
      {
        printf("  `- %s\n", last_contact);
        last_contact=NULL;
      }
      break;
    }

    if(!strcmp(rcmd[0], "list_group"))
    {
      if(last_online!=NULL)
      {
        printf("  `- %s\n\n", last_online);
        last_online=NULL;
      }
      printf("+ %s\n", rcmd[1]);
    }

    if(!strcmp(rcmd[0], "list_contact"))
    {
      if(last_online!=NULL)
      {
        printf("  |- %s\n", last_online);
      }
      if(last_contact!=NULL) { free(last_contact); }
      last_contact=strdup(rcmd[2]);
      last_online=online_only?NULL:last_contact;
    }

    if(!strcmp(rcmd[0], "buddy_login"))
    { last_online=last_contact; }

    destroy_command(rcmd, n);
  }
}

void eb_ctl_services(void)
{
  char * list_cmd[]={"list_services"};

  send_gui_message(list_cmd, 1);

  printf("Name\tOffline messaging?\tGroupchat?\n----\t------------------\t----------\n");

  while(1)
  {
    int n;
    char ** rcmd=read_gui_message(&n);

    if(!strcmp(rcmd[0], "list_services_done"))
    { break; }

    if(!strcmp(rcmd[0], "list_service"))
    {
      int cap=atoi(rcmd[3]);

      printf("%s\t%s\t\t\t%s\n", rcmd[1], (cap&0x1)?("Yes"):("No"), (cap&0x2)?("Yes"):("No"));
    }

    destroy_command(rcmd, n);
  }
}

void eb_ctl_status(void)
{
  char * list_cmd[]={"list_local_accounts"};
  int holding=0, held_waiting=0;

  send_gui_message(list_cmd, 1);

  printf("Service\tStatus\tDescription\tHandle\n-------\t------\t-----------\t------\n");

  while(1)
  {
    int n;
    char ** rcmd=read_gui_message(&n);
    if(rcmd == NULL) {
	printf("NULL Status\n");
	return;
    }
    if(!strcmp(rcmd[0], "list_local_accounts_done")) { break; }

    if(!strcmp(rcmd[0], "message_hold") && !strcmp(rcmd[1], "1")) { holding=1; }
    if(!strcmp(rcmd[0], "holding_message")) { held_waiting=1; }

    if(!strcmp(rcmd[0], "local_account_update"))
    {
      char * status="Offline";
      if(rcmd[3][0]=='1') { status="Opening"; }
      if(rcmd[4][0]=='1') { status="Ready"; }
      printf("%s\t%s\t%s%s\t%s\n", rcmd[2], status, rcmd[5], (strlen(rcmd[5])<8)?("\t"):(""), rcmd[1]);
    }

    destroy_command(rcmd, n);
  }

  printf("\nMessage hold %s\n", holding?"enabled":"disabled");
}

