#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>

#include "GUIcomms.h"
#include "eb-cmd.h"

void eb_cmd_connect(void)
{
  unsigned char cookie[8];

  char * homedir;
  char * cookiefile;
  FILE * dat;
  int gui_port, a;
  char * host;

  homedir=getenv("HOME");
  if(homedir==NULL)
  {
    fprintf(stderr, "Warning: No HOME environment variable\n");
    homedir=".";
  }

  cookiefile=malloc(strlen(homedir)+32);
  strcpy(cookiefile, homedir);
  strcat(cookiefile, "/.everybuddy/authcookie");

  if((dat=fopen(cookiefile, "r"))==NULL)
  {
    perror("Cannot open cookie file");
    exit(1);
  }

  gui_port=256*((unsigned char)fgetc(dat))+((unsigned char)fgetc(dat));

  for(a=0; a<8; a++)
  { cookie[a]=(unsigned char)fgetc(dat); }

  fclose(dat);

  fflush(stdout);

  host=getenv("EB_HOST");
  if(host==NULL) { host="127.0.0.1"; }

  if(connect_gui_socket(host, gui_port, cookie)<0)
  {
    perror("Could not connect to core");
    exit(1);
  }
}

void eb_cmd_getmsgs(void)
{
  int nmsgs=0;
  while(1)
  {
    int num_params;
    char ** command=read_gui_message(&num_params);

    if(!strcmp(command[0], "message_hold"))
    {
      if(command[1][0]=='1')
      {
        char * hcmd[]={"html_strip", "1"};
        char * cmd[]={"get_held_messages"};
        send_gui_message(hcmd, 2);
        send_gui_message(cmd, 1);
      } else {
        printf("Message hold is disabled. You are unable to receive sent messages.\nUse \"eb-ctl hold\" to turn on message hold.\n");
        return;
      }
    }

    if(!strcmp(command[0], "held_message") || !strcmp(command[0], "held_sent_message"))
    {
      char * datestring;
      time_t when=time(NULL)-atoi(command[1]);
      struct tm * local=localtime(&when);
      int pos=0;

      char * dotw[]={"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
      char * moty[]={"Jan","Feb","Mar","Apr","May","June","July","Aug","Sep",
	"Oct","Nov","Dec"};


      if(command[0][5]=='s')
      { pos+=printf("Sent to "); }

      pos+=printf("%s (%s):", command[3], command[2]);

      for(;pos<60;pos++) { fputc(' ', stdout); }

      printf("%02d:%02d  %s %d %s\n\t%s\n\n", local->tm_hour, local->tm_min,
	dotw[local->tm_wday], local->tm_mday, moty[local->tm_mon],
	command[7]);

      nmsgs++;
    }

    if(!strcmp(command[0], "error_dialog"))
    {
      char * resolve_cmd[]={"resolve_dialog", command[1]};
      printf("\t\t%s\n%s\n\n", command[2], command[3]);
      send_gui_message(resolve_cmd, 2);
    }

    if(!strcmp(command[0], "held_messages_done")) { break; }
  }

  if(nmsgs==0) { printf("No messages\n"); }
}

char * eb_cmd_get_group(char * contact)
{
  char * lcmd[]={"list_contacts"};
  char * retval;
  int b;

  send_gui_message(lcmd, 1);

  while(1)
  {
    char ** rcmd=read_gui_message(&b);

    if(!strcmp(rcmd[0], "list_contacts_done"))
    {
      return retval;
    }

    if(!strcmp(rcmd[0], "list_contact")) {
      if(!strcasecmp(contact, rcmd[2]))
      {
        retval=rcmd[1];
      }
    }
  }
}
