#include <stdio.h>
#include <unistd.h>
#ifdef __MINGW32__
#include <winsock2.h>
#define ECONNREFUSED WSAECONNREFUSED
#define read(a,b,c) recv(a,b,c,0)
#define write(a,b,c) send(a,b,c,0)
#else
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/poll.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netdb.h>
#endif
#include <sys/types.h>
#include <errno.h>

// Everybuddy GUI communications code

int gui_in, gui_out;

int send_gui_message(char ** command, int num_params)
{
  unsigned char c=num_params;
  int a;

  write(gui_out, &c, 1);

  for(a=0; a<num_params; a++)
  {
    int len=strlen(command[a]);
    c=len/256;
    write(gui_out, &c, 1);
    c=len%256;
    write(gui_out, &c, 1);

    write(gui_out, command[a], len);
  }

#ifdef __MINGW32__
  Sleep(10);
#else
  usleep(100);
#endif

  return 0;
}

char ** read_gui_message(int * num_params)
{
  unsigned char c, c2[2];
  char ** command;
  int a;

  if(read_m(gui_in, &c, 1)<1) { printf("ouchie 1\n"); return NULL; }
  *num_params=c;

  command=(char **)malloc(*num_params * sizeof(char *));

  for(a=0; a<*num_params; a++)
  {
    int size;

    if(read_m(gui_in, c2, 2)<2) { printf("ouchie 2\n"); return NULL; }
    size=c2[0]*256+c2[1];

    command[a]=(char *)malloc(size+1);
    if(read_m(gui_in, command[a], size)<size) { printf("ouchie 3\n"); return NULL; } // OUCH! mem leak, CBA to fix
    command[a][size]='\0';
  }

  return command;
}

int connect_gui_socket(char * hostname, int port, unsigned char * cookie)
{
  struct sockaddr_in sa;
  struct hostent     *hp;
  int a;
#ifdef __MINGW32__
  WSADATA wsaData;
  WSAStartup(MAKEWORD(2,0),&wsaData);
#endif

  if ((hp= gethostbyname(hostname)) == NULL) { /* do we know the host's */
    errno= ECONNREFUSED;                       /* address? */
    return(-1);                                /* no */
  }

  memset(&sa,0,sizeof(sa));
  memcpy((char *)&sa.sin_addr,hp->h_addr,hp->h_length);     /* set address */
  sa.sin_family= hp->h_addrtype;
  sa.sin_port= htons((u_short)port);

  if ((gui_out= socket(hp->h_addrtype,SOCK_STREAM,0)) < 0)     /* get socket */
    return(-1);
  if (connect(gui_out,(struct sockaddr *)&sa,sizeof sa) < 0) { /* connect */
    close(gui_out);
    return(-1);
  }

  write(gui_out, cookie, 8);
  gui_in=gui_out;
  return 0;
}

int read_m(int sock, char * dest, int num)
{
  int pos=0;
  int read_result=0;
  int a;

  while(pos<num)
  {
    read_result=read(sock, dest+pos, num-pos);
    if(read_result<1) { return -1; }
    pos+=read_result;

    if(num>2)
    {
      //for(a=0; a<read_result; a++) { printf("%c", dest[pos+a]); }
      //printf("\n");
    }
  }

  return num;
}

void destroy_command(char ** cmd, int num)
{
  int a;
  for(a=0; a<num; a++)
  {
    free(cmd[a]);
  }

  free(cmd);
}
